/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import sun.lwawt.macosx.CMenuBar;
import sun.lwawt.macosx.CMenuComponent;
import sun.lwawt.macosx.CMenuItem;
import sun.lwawt.macosx.CPopupMenu;
import sun.lwawt.macosx.LWCToolkit;

public class CMenu
extends CMenuItem
implements MenuPeer {
    public CMenu(Menu menu) {
        super(menu);
    }

    @Override
    protected void initialize(MenuItem menuItem) {
        this.setLabel(menuItem.getLabel());
        this.setEnabled(menuItem.isEnabled());
    }

    @Override
    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Menu menu = (Menu)this.getTarget();
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = menu.getItem(i);
            MenuItemPeer menuItemPeer = (MenuItemPeer)LWCToolkit.targetToPeer(menuItem);
            if (menuItemPeer == null) continue;
            menuItemPeer.setEnabled(bl && menuItem.isEnabled());
        }
    }

    @Override
    protected long createModel() {
        CMenuComponent cMenuComponent = (CMenuComponent)LWCToolkit.targetToPeer(this.getTarget().getParent());
        if (cMenuComponent instanceof CMenu || cMenuComponent instanceof CPopupMenu) {
            return this.nativeCreateSubMenu(cMenuComponent.getModel());
        }
        if (cMenuComponent instanceof CMenuBar) {
            MenuBar menuBar = (MenuBar)this.getTarget().getParent();
            boolean bl = menuBar.getHelpMenu() == this.getTarget();
            int n = ((CMenuBar)cMenuComponent).getNextInsertionIndex();
            return this.nativeCreateMenu(cMenuComponent.getModel(), bl, n);
        }
        throw new InternalError("Parent must be CMenu or CMenuBar");
    }

    @Override
    public void addItem(MenuItem menuItem) {
    }

    @Override
    public void delItem(int n) {
        this.nativeDeleteItem(this.getModel(), n);
    }

    @Override
    public void setLabel(String string) {
        this.nativeSetMenuTitle(this.getModel(), string);
        super.setLabel(string);
    }

    @Override
    public void addSeparator() {
        this.nativeAddSeparator(this.getModel());
    }

    public long getNativeMenu() {
        return this.nativeGetNSMenu(this.getModel());
    }

    private native long nativeCreateMenu(long var1, boolean var3, int var4);

    private native long nativeCreateSubMenu(long var1);

    private native void nativeSetMenuTitle(long var1, String var3);

    private native void nativeAddSeparator(long var1);

    private native void nativeDeleteItem(long var1, int var3);

    private native long nativeGetNSMenu(long var1);
}

