/*
 * Decompiled with CFR 0.152.
 */
package java.net;

public class URISyntaxException
extends Exception {
    private static final long serialVersionUID = 2137979680897488891L;
    private String input;
    private int index;

    public URISyntaxException(String string, String string2, int n) {
        super(string2);
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        this.input = string;
        this.index = n;
    }

    public URISyntaxException(String string, String string2) {
        this(string, string2, -1);
    }

    public String getInput() {
        return this.input;
    }

    public String getReason() {
        return super.getMessage();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getReason());
        if (this.index > -1) {
            stringBuffer.append(" at index ");
            stringBuffer.append(this.index);
        }
        stringBuffer.append(": ");
        stringBuffer.append(this.input);
        return stringBuffer.toString();
    }
}

