/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Label;
import java.awt.peer.LabelPeer;
import javax.swing.JLabel;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.PlatformComponent;

final class LWLabelPeer
extends LWComponentPeer<Label, JLabel>
implements LabelPeer {
    private static final int TEXT_XPAD = 5;
    private static final int TEXT_YPAD = 1;

    LWLabelPeer(Label label, PlatformComponent platformComponent) {
        super(label, platformComponent);
    }

    @Override
    protected JLabel createDelegate() {
        JLabel jLabel = new JLabel();
        jLabel.setVerticalAlignment(1);
        return jLabel;
    }

    @Override
    void initializeImpl() {
        super.initializeImpl();
        this.setText(((Label)this.getTarget()).getText());
        this.setAlignment(((Label)this.getTarget()).getAlignment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String string) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((JLabel)this.getDelegate()).setText(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlignment(int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((JLabel)this.getDelegate()).setHorizontalAlignment(LWLabelPeer.convertAlignment(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize() {
        int n = 5;
        int n2 = 1;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics != null) {
            String string;
            Object object = this.getDelegateLock();
            synchronized (object) {
                string = ((JLabel)this.getDelegate()).getText();
            }
            if (string != null) {
                n += fontMetrics.stringWidth(string);
            }
            n2 += fontMetrics.getHeight();
        }
        return new Dimension(n, n2);
    }

    private static int convertAlignment(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 4;
            }
        }
        return 2;
    }
}

