/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Locale;
import javax.net.SocketFactory;
import javax.net.ssl.DefaultSSLSocketFactory;
import javax.net.ssl.SSLContext;
import sun.security.action.GetPropertyAction;

public abstract class SSLSocketFactory
extends SocketFactory {
    private static SSLSocketFactory theFactory;
    private static boolean propertyChecked;
    static final boolean DEBUG;

    private static void log(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static synchronized SocketFactory getDefault() {
        if (theFactory != null) {
            return theFactory;
        }
        if (!propertyChecked) {
            propertyChecked = true;
            String string = SSLSocketFactory.getSecurityProperty("ssl.SocketFactory.provider");
            if (string != null) {
                SSLSocketFactory.log("setting up default SSLSocketFactory");
                try {
                    Class<?> clazz;
                    block9: {
                        clazz = null;
                        try {
                            clazz = Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                            if (classLoader == null) break block9;
                            clazz = classLoader.loadClass(string);
                        }
                    }
                    SSLSocketFactory.log("class " + string + " is loaded");
                    SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)clazz.newInstance();
                    SSLSocketFactory.log("instantiated an instance of class " + string);
                    theFactory = sSLSocketFactory;
                    return sSLSocketFactory;
                }
                catch (Exception exception) {
                    SSLSocketFactory.log("SSLSocketFactory instantiation failed: " + exception.toString());
                    theFactory = new DefaultSSLSocketFactory(exception);
                    return theFactory;
                }
            }
        }
        try {
            return SSLContext.getDefault().getSocketFactory();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return new DefaultSSLSocketFactory(noSuchAlgorithmException);
        }
    }

    static String getSecurityProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string2 = Security.getProperty(string);
                if (string2 != null && (string2 = string2.trim()).length() == 0) {
                    string2 = null;
                }
                return string2;
            }
        });
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;

    public Socket createSocket(Socket socket, InputStream inputStream, boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("javax.net.debug", "")).toLowerCase(Locale.ENGLISH);
        DEBUG = string.contains("all") || string.contains("ssl");
    }
}

