/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    private static final Actions SHARED_ACTION = new Actions();
    private static Dimension minSize = new Dimension(0, 0);
    private static Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private Handler handler;
    private PropertyChangeListener pcl;
    protected JDesktopPane desktop;
    protected DesktopManager desktopManager;
    @Deprecated
    protected KeyStroke minimizeKey;
    @Deprecated
    protected KeyStroke maximizeKey;
    @Deprecated
    protected KeyStroke closeKey;
    @Deprecated
    protected KeyStroke navigateKey;
    @Deprecated
    protected KeyStroke navigateKey2;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.desktop = (JDesktopPane)jComponent;
        this.installDefaults();
        this.installDesktopManager();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.desktop = null;
        this.handler = null;
    }

    protected void installDefaults() {
        if (this.desktop.getBackground() == null || this.desktop.getBackground() instanceof UIResource) {
            this.desktop.setBackground(UIManager.getColor("Desktop.background"));
        }
        LookAndFeel.installProperty(this.desktop, "opaque", Boolean.TRUE);
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.pcl = this.createPropertyChangeListener();
        this.desktop.addPropertyChangeListener(this.pcl);
    }

    protected void uninstallListeners() {
        this.desktop.removePropertyChangeListener(this.pcl);
        this.pcl = null;
    }

    protected void installDesktopManager() {
        this.desktopManager = this.desktop.getDesktopManager();
        if (this.desktopManager == null) {
            this.desktopManager = new BasicDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
        }
    }

    protected void uninstallDesktopManager() {
        if (this.desktop.getDesktopManager() instanceof UIResource) {
            this.desktop.setDesktopManager(null);
        }
        this.desktopManager = null;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 2, inputMap);
        }
        if ((inputMap = this.getInputMap(1)) != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 1, inputMap);
        }
        LazyActionMap.installLazyActionMap(this.desktop, BasicDesktopPaneUI.class, "DesktopPane.actionMap");
        this.registerKeyboardActions();
    }

    protected void registerKeyboardActions() {
    }

    protected void unregisterKeyboardActions() {
    }

    InputMap getInputMap(int n) {
        if (n == 2) {
            return this.createInputMap(n);
        }
        if (n == 1) {
            return (InputMap)DefaultLookup.get(this.desktop, this, "Desktop.ancestorInputMap");
        }
        return null;
    }

    InputMap createInputMap(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])DefaultLookup.get(this.desktop, this, "Desktop.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.desktop, objectArray);
        }
        return null;
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions(Actions.RESTORE));
        lazyActionMap.put(new Actions(Actions.CLOSE));
        lazyActionMap.put(new Actions(Actions.MOVE));
        lazyActionMap.put(new Actions(Actions.RESIZE));
        lazyActionMap.put(new Actions(Actions.LEFT));
        lazyActionMap.put(new Actions(Actions.SHRINK_LEFT));
        lazyActionMap.put(new Actions(Actions.RIGHT));
        lazyActionMap.put(new Actions(Actions.SHRINK_RIGHT));
        lazyActionMap.put(new Actions(Actions.UP));
        lazyActionMap.put(new Actions(Actions.SHRINK_UP));
        lazyActionMap.put(new Actions(Actions.DOWN));
        lazyActionMap.put(new Actions(Actions.SHRINK_DOWN));
        lazyActionMap.put(new Actions(Actions.ESCAPE));
        lazyActionMap.put(new Actions(Actions.MINIMIZE));
        lazyActionMap.put(new Actions(Actions.MAXIMIZE));
        lazyActionMap.put(new Actions(Actions.NEXT_FRAME));
        lazyActionMap.put(new Actions(Actions.PREVIOUS_FRAME));
        lazyActionMap.put(new Actions(Actions.NAVIGATE_NEXT));
        lazyActionMap.put(new Actions(Actions.NAVIGATE_PREVIOUS));
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
        SwingUtilities.replaceUIInputMap(this.desktop, 2, null);
        SwingUtilities.replaceUIInputMap(this.desktop, 1, null);
        SwingUtilities.replaceUIActionMap(this.desktop, null);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return minSize;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return maxSize;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected class NavigateAction
    extends AbstractAction {
        protected NavigateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDesktopPane jDesktopPane = (JDesktopPane)actionEvent.getSource();
            jDesktopPane.selectFrame(true);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        protected MaximizeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDesktopPane jDesktopPane = (JDesktopPane)actionEvent.getSource();
            SHARED_ACTION.setState(jDesktopPane, Actions.MAXIMIZE);
        }

        @Override
        public boolean isEnabled() {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                return jInternalFrame.isMaximizable();
            }
            return false;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        protected MinimizeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDesktopPane jDesktopPane = (JDesktopPane)actionEvent.getSource();
            SHARED_ACTION.setState(jDesktopPane, Actions.MINIMIZE);
        }

        @Override
        public boolean isEnabled() {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                return jInternalFrame.isIconifiable();
            }
            return false;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        protected CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDesktopPane jDesktopPane = (JDesktopPane)actionEvent.getSource();
            SHARED_ACTION.setState(jDesktopPane, Actions.CLOSE);
        }

        @Override
        public boolean isEnabled() {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                return jInternalFrame.isClosable();
            }
            return false;
        }
    }

    protected class OpenAction
    extends AbstractAction {
        protected OpenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDesktopPane jDesktopPane = (JDesktopPane)actionEvent.getSource();
            SHARED_ACTION.setState(jDesktopPane, Actions.RESTORE);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    private static class Actions
    extends UIAction {
        private static String CLOSE = "close";
        private static String ESCAPE = "escape";
        private static String MAXIMIZE = "maximize";
        private static String MINIMIZE = "minimize";
        private static String MOVE = "move";
        private static String RESIZE = "resize";
        private static String RESTORE = "restore";
        private static String LEFT = "left";
        private static String RIGHT = "right";
        private static String UP = "up";
        private static String DOWN = "down";
        private static String SHRINK_LEFT = "shrinkLeft";
        private static String SHRINK_RIGHT = "shrinkRight";
        private static String SHRINK_UP = "shrinkUp";
        private static String SHRINK_DOWN = "shrinkDown";
        private static String NEXT_FRAME = "selectNextFrame";
        private static String PREVIOUS_FRAME = "selectPreviousFrame";
        private static String NAVIGATE_NEXT = "navigateNext";
        private static String NAVIGATE_PREVIOUS = "navigatePrevious";
        private final int MOVE_RESIZE_INCREMENT = 10;
        private static boolean moving = false;
        private static boolean resizing = false;
        private static JInternalFrame sourceFrame = null;
        private static Component focusOwner = null;

        Actions() {
            super(null);
        }

        Actions(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDesktopPane jDesktopPane = (JDesktopPane)actionEvent.getSource();
            String string = this.getName();
            if (CLOSE == string || MAXIMIZE == string || MINIMIZE == string || RESTORE == string) {
                this.setState(jDesktopPane, string);
            } else if (ESCAPE == string) {
                if (sourceFrame == jDesktopPane.getSelectedFrame() && focusOwner != null) {
                    focusOwner.requestFocus();
                }
                moving = false;
                resizing = false;
                sourceFrame = null;
                focusOwner = null;
            } else if (MOVE == string || RESIZE == string) {
                sourceFrame = jDesktopPane.getSelectedFrame();
                if (sourceFrame == null) {
                    return;
                }
                moving = string == MOVE;
                resizing = string == RESIZE;
                focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (!SwingUtilities.isDescendingFrom(focusOwner, sourceFrame)) {
                    focusOwner = null;
                }
                sourceFrame.requestFocus();
            } else if (LEFT == string || RIGHT == string || UP == string || DOWN == string || SHRINK_RIGHT == string || SHRINK_LEFT == string || SHRINK_UP == string || SHRINK_DOWN == string) {
                JInternalFrame jInternalFrame = jDesktopPane.getSelectedFrame();
                if (sourceFrame == null || jInternalFrame != sourceFrame || KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() != sourceFrame) {
                    return;
                }
                Insets insets = UIManager.getInsets("Desktop.minOnScreenInsets");
                Dimension dimension = jInternalFrame.getSize();
                Dimension dimension2 = jInternalFrame.getMinimumSize();
                int n = jDesktopPane.getWidth();
                int n2 = jDesktopPane.getHeight();
                Point point = jInternalFrame.getLocation();
                if (LEFT == string) {
                    if (moving) {
                        jInternalFrame.setLocation(point.x + dimension.width - 10 < insets.right ? -dimension.width + insets.right : point.x - 10, point.y);
                    } else if (resizing) {
                        jInternalFrame.setLocation(point.x - 10, point.y);
                        jInternalFrame.setSize(dimension.width + 10, dimension.height);
                    }
                } else if (RIGHT == string) {
                    if (moving) {
                        jInternalFrame.setLocation(point.x + 10 > n - insets.left ? n - insets.left : point.x + 10, point.y);
                    } else if (resizing) {
                        jInternalFrame.setSize(dimension.width + 10, dimension.height);
                    }
                } else if (UP == string) {
                    if (moving) {
                        jInternalFrame.setLocation(point.x, point.y + dimension.height - 10 < insets.bottom ? -dimension.height + insets.bottom : point.y - 10);
                    } else if (resizing) {
                        jInternalFrame.setLocation(point.x, point.y - 10);
                        jInternalFrame.setSize(dimension.width, dimension.height + 10);
                    }
                } else if (DOWN == string) {
                    if (moving) {
                        jInternalFrame.setLocation(point.x, point.y + 10 > n2 - insets.top ? n2 - insets.top : point.y + 10);
                    } else if (resizing) {
                        jInternalFrame.setSize(dimension.width, dimension.height + 10);
                    }
                } else if (SHRINK_LEFT == string && resizing) {
                    int n3 = dimension2.width < dimension.width - 10 ? 10 : dimension.width - dimension2.width;
                    if (point.x + dimension.width - n3 < insets.left) {
                        n3 = point.x + dimension.width - insets.left;
                    }
                    jInternalFrame.setSize(dimension.width - n3, dimension.height);
                } else if (SHRINK_RIGHT == string && resizing) {
                    int n4 = dimension2.width < dimension.width - 10 ? 10 : dimension.width - dimension2.width;
                    if (point.x + n4 > n - insets.right) {
                        n4 = n - insets.right - point.x;
                    }
                    jInternalFrame.setLocation(point.x + n4, point.y);
                    jInternalFrame.setSize(dimension.width - n4, dimension.height);
                } else if (SHRINK_UP == string && resizing) {
                    int n5 = dimension2.height < dimension.height - 10 ? 10 : dimension.height - dimension2.height;
                    if (point.y + dimension.height - n5 < insets.bottom) {
                        n5 = point.y + dimension.height - insets.bottom;
                    }
                    jInternalFrame.setSize(dimension.width, dimension.height - n5);
                } else if (SHRINK_DOWN == string && resizing) {
                    int n6 = dimension2.height < dimension.height - 10 ? 10 : dimension.height - dimension2.height;
                    if (point.y + n6 > n2 - insets.top) {
                        n6 = n2 - insets.top - point.y;
                    }
                    jInternalFrame.setLocation(point.x, point.y + n6);
                    jInternalFrame.setSize(dimension.width, dimension.height - n6);
                }
            } else if (NEXT_FRAME == string || PREVIOUS_FRAME == string) {
                jDesktopPane.selectFrame(string == NEXT_FRAME);
            } else if (NAVIGATE_NEXT == string || NAVIGATE_PREVIOUS == string) {
                FocusTraversalPolicy focusTraversalPolicy;
                Container container;
                boolean bl = true;
                if (NAVIGATE_PREVIOUS == string) {
                    bl = false;
                }
                if ((container = jDesktopPane.getFocusCycleRootAncestor()) != null && (focusTraversalPolicy = container.getFocusTraversalPolicy()) != null && focusTraversalPolicy instanceof SortingFocusTraversalPolicy) {
                    SortingFocusTraversalPolicy sortingFocusTraversalPolicy = (SortingFocusTraversalPolicy)focusTraversalPolicy;
                    boolean bl2 = sortingFocusTraversalPolicy.getImplicitDownCycleTraversal();
                    try {
                        sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(false);
                        if (bl) {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(jDesktopPane);
                        } else {
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(jDesktopPane);
                        }
                    }
                    finally {
                        sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(bl2);
                    }
                }
            }
        }

        private void setState(JDesktopPane jDesktopPane, String string) {
            if (string == CLOSE) {
                JInternalFrame jInternalFrame = jDesktopPane.getSelectedFrame();
                if (jInternalFrame == null) {
                    return;
                }
                jInternalFrame.doDefaultCloseAction();
            } else if (string == MAXIMIZE) {
                JInternalFrame jInternalFrame = jDesktopPane.getSelectedFrame();
                if (jInternalFrame == null) {
                    return;
                }
                if (!jInternalFrame.isMaximum()) {
                    if (jInternalFrame.isIcon()) {
                        try {
                            jInternalFrame.setIcon(false);
                            jInternalFrame.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else {
                        try {
                            jInternalFrame.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                }
            } else if (string == MINIMIZE) {
                JInternalFrame jInternalFrame = jDesktopPane.getSelectedFrame();
                if (jInternalFrame == null) {
                    return;
                }
                if (!jInternalFrame.isIcon()) {
                    try {
                        jInternalFrame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            } else if (string == RESTORE) {
                JInternalFrame jInternalFrame = jDesktopPane.getSelectedFrame();
                if (jInternalFrame == null) {
                    return;
                }
                try {
                    if (jInternalFrame.isIcon()) {
                        jInternalFrame.setIcon(false);
                    } else if (jInternalFrame.isMaximum()) {
                        jInternalFrame.setMaximum(false);
                    }
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isEnabled(Object object) {
            if (object instanceof JDesktopPane) {
                JDesktopPane jDesktopPane = (JDesktopPane)object;
                String string = this.getName();
                if (string == NEXT_FRAME || string == PREVIOUS_FRAME) {
                    return true;
                }
                JInternalFrame jInternalFrame = jDesktopPane.getSelectedFrame();
                if (jInternalFrame == null) {
                    return false;
                }
                if (string == CLOSE) {
                    return jInternalFrame.isClosable();
                }
                if (string == MINIMIZE) {
                    return jInternalFrame.isIconifiable();
                }
                if (string == MAXIMIZE) {
                    return jInternalFrame.isMaximizable();
                }
                return true;
            }
            return false;
        }
    }

    private class BasicDesktopManager
    extends DefaultDesktopManager
    implements UIResource {
        private BasicDesktopManager() {
        }
    }

    private class Handler
    implements PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("desktopManager" == string) {
                BasicDesktopPaneUI.this.installDesktopManager();
            }
        }
    }
}

