/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.ListIterator;

public class ImageCache {
    private int maxCount;
    private final LinkedList<SoftReference<Entry>> entries;

    public ImageCache(int n) {
        this.maxCount = n;
        this.entries = new LinkedList();
    }

    void setMaxCount(int n) {
        this.maxCount = n;
    }

    public void flush() {
        this.entries.clear();
    }

    private Entry getEntry(Object object, GraphicsConfiguration graphicsConfiguration, int n, int n2, Object[] objectArray) {
        Entry entry;
        ListIterator listIterator = this.entries.listIterator();
        while (listIterator.hasNext()) {
            SoftReference softReference = (SoftReference)listIterator.next();
            entry = (Entry)softReference.get();
            if (entry == null) {
                listIterator.remove();
                continue;
            }
            if (!entry.equals(graphicsConfiguration, n, n2, objectArray)) continue;
            listIterator.remove();
            this.entries.addFirst(softReference);
            return entry;
        }
        entry = new Entry(graphicsConfiguration, n, n2, objectArray);
        if (this.entries.size() >= this.maxCount) {
            this.entries.removeLast();
        }
        this.entries.addFirst(new SoftReference<Entry>(entry));
        return entry;
    }

    public Image getImage(Object object, GraphicsConfiguration graphicsConfiguration, int n, int n2, Object[] objectArray) {
        Entry entry = this.getEntry(object, graphicsConfiguration, n, n2, objectArray);
        return entry.getImage();
    }

    public void setImage(Object object, GraphicsConfiguration graphicsConfiguration, int n, int n2, Object[] objectArray, Image image) {
        Entry entry = this.getEntry(object, graphicsConfiguration, n, n2, objectArray);
        entry.setImage(image);
    }

    private static class Entry {
        private final GraphicsConfiguration config;
        private final int w;
        private final int h;
        private final Object[] args;
        private Image image;

        Entry(GraphicsConfiguration graphicsConfiguration, int n, int n2, Object[] objectArray) {
            this.config = graphicsConfiguration;
            this.args = objectArray;
            this.w = n;
            this.h = n2;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public Image getImage() {
            return this.image;
        }

        public String toString() {
            String string = super.toString() + "[ graphicsConfig=" + this.config + ", image=" + this.image + ", w=" + this.w + ", h=" + this.h;
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    string = string + ", " + this.args[i];
                }
            }
            string = string + "]";
            return string;
        }

        public boolean equals(GraphicsConfiguration graphicsConfiguration, int n, int n2, Object[] objectArray) {
            if (this.w == n && this.h == n2 && (this.config != null && this.config.equals(graphicsConfiguration) || this.config == null && graphicsConfiguration == null)) {
                if (this.args == null && objectArray == null) {
                    return true;
                }
                if (this.args != null && objectArray != null && this.args.length == objectArray.length) {
                    for (int i = objectArray.length - 1; i >= 0; --i) {
                        Object object = this.args[i];
                        Object object2 = objectArray[i];
                        if ((object != null || object2 == null) && (object == null || object.equals(object2))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

