/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

class MethodHandleStatics {
    static final Unsafe UNSAFE = Unsafe.getUnsafe();
    static final boolean DEBUG_METHOD_HANDLE_NAMES;
    static final boolean DUMP_CLASS_FILES;
    static final boolean TRACE_INTERPRETER;
    static final boolean TRACE_METHOD_LINKAGE;
    static final Integer COMPILE_THRESHOLD;

    private MethodHandleStatics() {
    }

    static String getNameString(MethodHandle methodHandle, MethodType methodType) {
        if (methodType == null) {
            methodType = methodHandle.type();
        }
        MemberName memberName = null;
        if (methodHandle != null) {
            memberName = methodHandle.internalMemberName();
        }
        if (memberName == null) {
            return "invoke" + methodType;
        }
        return memberName.getName() + methodType;
    }

    static String getNameString(MethodHandle methodHandle, MethodHandle methodHandle2) {
        return MethodHandleStatics.getNameString(methodHandle, methodHandle2 == null ? (MethodType)null : methodHandle2.type());
    }

    static String getNameString(MethodHandle methodHandle) {
        return MethodHandleStatics.getNameString(methodHandle, (MethodType)null);
    }

    static String addTypeString(Object object, MethodHandle methodHandle) {
        String string = String.valueOf(object);
        if (methodHandle == null) {
            return string;
        }
        int n = string.indexOf(40);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string + methodHandle.type();
    }

    static InternalError newInternalError(String string, Throwable throwable) {
        InternalError internalError = new InternalError(string);
        internalError.initCause(throwable);
        return internalError;
    }

    static InternalError newInternalError(Throwable throwable) {
        InternalError internalError = new InternalError();
        internalError.initCause(throwable);
        return internalError;
    }

    static RuntimeException newIllegalStateException(String string) {
        return new IllegalStateException(string);
    }

    static RuntimeException newIllegalStateException(String string, Object object) {
        return new IllegalStateException(MethodHandleStatics.message(string, object));
    }

    static RuntimeException newIllegalArgumentException(String string) {
        return new IllegalArgumentException(string);
    }

    static RuntimeException newIllegalArgumentException(String string, Object object) {
        return new IllegalArgumentException(MethodHandleStatics.message(string, object));
    }

    static RuntimeException newIllegalArgumentException(String string, Object object, Object object2) {
        return new IllegalArgumentException(MethodHandleStatics.message(string, object, object2));
    }

    static Error uncaughtException(Throwable throwable) {
        throw MethodHandleStatics.newInternalError("uncaught exception", throwable);
    }

    static Error NYI() {
        throw new AssertionError((Object)"NYI");
    }

    private static String message(String string, Object object) {
        if (object != null) {
            string = string + ": " + object;
        }
        return string;
    }

    private static String message(String string, Object object, Object object2) {
        if (object != null || object2 != null) {
            string = string + ": " + object + ", " + object2;
        }
        return string;
    }

    static {
        final Object[] objectArray = new Object[]{false, false, false, false, null};
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                objectArray[0] = Boolean.getBoolean("java.lang.invoke.MethodHandle.DEBUG_NAMES");
                objectArray[1] = Boolean.getBoolean("java.lang.invoke.MethodHandle.DUMP_CLASS_FILES");
                objectArray[2] = Boolean.getBoolean("java.lang.invoke.MethodHandle.TRACE_INTERPRETER");
                objectArray[3] = Boolean.getBoolean("java.lang.invoke.MethodHandle.TRACE_METHOD_LINKAGE");
                objectArray[4] = Integer.getInteger("java.lang.invoke.MethodHandle.COMPILE_THRESHOLD");
                return null;
            }
        });
        DEBUG_METHOD_HANDLE_NAMES = (Boolean)objectArray[0];
        DUMP_CLASS_FILES = (Boolean)objectArray[1];
        TRACE_INTERPRETER = (Boolean)objectArray[2];
        TRACE_METHOD_LINKAGE = (Boolean)objectArray[3];
        COMPILE_THRESHOLD = (Integer)objectArray[4];
    }
}

