/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class OutputFeedback
extends FeedbackCipher {
    private byte[] k = null;
    private byte[] register = null;
    private int numBytes;
    private byte[] registerSave = null;

    OutputFeedback(SymmetricCipher symmetricCipher, int n) {
        super(symmetricCipher);
        if (n > this.blockSize) {
            n = this.blockSize;
        }
        this.numBytes = n;
        this.k = new byte[this.blockSize];
        this.register = new byte[this.blockSize];
    }

    @Override
    String getFeedback() {
        return "OFB";
    }

    @Override
    void init(boolean bl, String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException {
        if (byArray == null || byArray2 == null || byArray2.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        this.iv = byArray2;
        this.reset();
        this.embeddedCipher.init(false, string, byArray);
    }

    @Override
    void reset() {
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
    }

    @Override
    void save() {
        if (this.registerSave == null) {
            this.registerSave = new byte[this.blockSize];
        }
        System.arraycopy(this.register, 0, this.registerSave, 0, this.blockSize);
    }

    @Override
    void restore() {
        System.arraycopy(this.registerSave, 0, this.register, 0, this.blockSize);
    }

    @Override
    void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5 = this.blockSize - this.numBytes;
        int n6 = n2 % this.numBytes;
        if (n5 == 0) {
            int n7;
            for (n4 = n2 / this.numBytes; n4 > 0; --n4) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (n7 = 0; n7 < this.numBytes; ++n7) {
                    byArray2[n7 + n3] = (byte)(this.k[n7] ^ byArray[n7 + n]);
                }
                System.arraycopy(this.k, 0, this.register, 0, this.numBytes);
                n += this.numBytes;
                n3 += this.numBytes;
            }
            if (n6 > 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (n7 = 0; n7 < n6; ++n7) {
                    byArray2[n7 + n3] = (byte)(this.k[n7] ^ byArray[n7 + n]);
                }
                System.arraycopy(this.k, 0, this.register, 0, this.numBytes);
            }
        } else {
            int n8;
            while (n4 > 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (n8 = 0; n8 < this.numBytes; ++n8) {
                    byArray2[n8 + n3] = (byte)(this.k[n8] ^ byArray[n8 + n]);
                }
                System.arraycopy(this.register, this.numBytes, this.register, 0, n5);
                System.arraycopy(this.k, 0, this.register, n5, this.numBytes);
                n += this.numBytes;
                n3 += this.numBytes;
                --n4;
            }
            if (n6 > 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (n8 = 0; n8 < n6; ++n8) {
                    byArray2[n8 + n3] = (byte)(this.k[n8] ^ byArray[n8 + n]);
                }
                System.arraycopy(this.register, this.numBytes, this.register, 0, n5);
                System.arraycopy(this.k, 0, this.register, n5, this.numBytes);
            }
        }
    }

    @Override
    void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.encrypt(byArray, n, n2, byArray2, n3);
    }
}

