/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Comparator;
import java.util.DualPivotQuicksort;
import java.util.TimSort;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinTask;

class ArraysParallelSortHelpers {
    ArraysParallelSortHelpers() {
    }

    static final class FJDouble {
        FJDouble() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final double[] a;
            final double[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> countedCompleter, double[] dArray, double[] dArray2, int n, int n2, int n3, int n4, int n5, int n6) {
                super(countedCompleter);
                this.a = dArray;
                this.w = dArray2;
                this.lbase = n;
                this.lsize = n2;
                this.rbase = n3;
                this.rsize = n4;
                this.wbase = n5;
                this.gran = n6;
            }

            @Override
            public final void compute() {
                int n;
                int n2;
                double[] dArray = this.a;
                double[] dArray2 = this.w;
                int n3 = this.lbase;
                int n4 = this.lsize;
                int n5 = this.rbase;
                int n6 = this.rsize;
                int n7 = this.wbase;
                int n8 = this.gran;
                if (dArray == null || dArray2 == null || n3 < 0 || n5 < 0 || n7 < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int n9;
                    int n10;
                    double d;
                    if (n4 >= n6) {
                        if (n4 <= n8) break;
                        n2 = n6;
                        n = n4 >>> 1;
                        d = dArray[n + n3];
                        n10 = 0;
                        while (n10 < n2) {
                            n9 = n10 + n2 >>> 1;
                            if (d <= dArray[n9 + n5]) {
                                n2 = n9;
                                continue;
                            }
                            n10 = n9 + 1;
                        }
                    } else {
                        if (n6 <= n8) break;
                        n = n4;
                        n2 = n6 >>> 1;
                        d = dArray[n2 + n5];
                        n10 = 0;
                        while (n10 < n) {
                            n9 = n10 + n >>> 1;
                            if (d <= dArray[n9 + n3]) {
                                n = n9;
                                continue;
                            }
                            n10 = n9 + 1;
                        }
                    }
                    Merger merger = new Merger(this, dArray, dArray2, n3 + n, n4 - n, n5 + n2, n6 - n2, n7 + n + n2, n8);
                    n6 = n2;
                    n4 = n;
                    this.addToPendingCount(1);
                    merger.fork();
                }
                n = n3 + n4;
                n2 = n5 + n6;
                while (n3 < n && n5 < n2) {
                    double d;
                    double d2;
                    double d3;
                    double d4 = dArray[n3];
                    double d5 = dArray[n5];
                    if (d3 <= d2) {
                        ++n3;
                        d = d4;
                    } else {
                        ++n5;
                        d = d5;
                    }
                    dArray2[n7++] = d;
                }
                if (n5 < n2) {
                    System.arraycopy(dArray, n5, dArray2, n7, n2 - n5);
                } else if (n3 < n) {
                    System.arraycopy(dArray, n3, dArray2, n7, n - n3);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final double[] a;
            final double[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> countedCompleter, double[] dArray, double[] dArray2, int n, int n2, int n3, int n4) {
                super(countedCompleter);
                this.a = dArray;
                this.w = dArray2;
                this.base = n;
                this.size = n2;
                this.wbase = n3;
                this.gran = n4;
            }

            @Override
            public final void compute() {
                CountedCompleter countedCompleter = this;
                double[] dArray = this.a;
                double[] dArray2 = this.w;
                int n = this.base;
                int n2 = this.size;
                int n3 = this.wbase;
                int n4 = this.gran;
                while (n2 > n4) {
                    int n5 = n2 >>> 1;
                    int n6 = n5 >>> 1;
                    int n7 = n5 + n6;
                    Relay relay = new Relay(new Merger(countedCompleter, dArray2, dArray, n3, n5, n3 + n5, n2 - n5, n, n4));
                    Relay relay2 = new Relay(new Merger(relay, dArray, dArray2, n + n5, n6, n + n7, n2 - n7, n3 + n5, n4));
                    new Sorter(relay2, dArray, dArray2, n + n7, n2 - n7, n3 + n7, n4).fork();
                    new Sorter(relay2, dArray, dArray2, n + n5, n6, n3 + n5, n4).fork();
                    Relay relay3 = new Relay(new Merger(relay, dArray, dArray2, n, n6, n + n6, n5 - n6, n3, n4));
                    new Sorter(relay3, dArray, dArray2, n + n6, n5 - n6, n3 + n6, n4).fork();
                    countedCompleter = new EmptyCompleter(relay3);
                    n2 = n6;
                }
                DualPivotQuicksort.sort(dArray, n, n + n2 - 1, dArray2, n3, n2);
                countedCompleter.tryComplete();
            }
        }
    }

    static final class FJFloat {
        FJFloat() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final float[] a;
            final float[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> countedCompleter, float[] fArray, float[] fArray2, int n, int n2, int n3, int n4, int n5, int n6) {
                super(countedCompleter);
                this.a = fArray;
                this.w = fArray2;
                this.lbase = n;
                this.lsize = n2;
                this.rbase = n3;
                this.rsize = n4;
                this.wbase = n5;
                this.gran = n6;
            }

            @Override
            public final void compute() {
                int n;
                int n2;
                float[] fArray = this.a;
                float[] fArray2 = this.w;
                int n3 = this.lbase;
                int n4 = this.lsize;
                int n5 = this.rbase;
                int n6 = this.rsize;
                int n7 = this.wbase;
                int n8 = this.gran;
                if (fArray == null || fArray2 == null || n3 < 0 || n5 < 0 || n7 < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int n9;
                    int n10;
                    float f;
                    if (n4 >= n6) {
                        if (n4 <= n8) break;
                        n2 = n6;
                        n = n4 >>> 1;
                        f = fArray[n + n3];
                        n10 = 0;
                        while (n10 < n2) {
                            n9 = n10 + n2 >>> 1;
                            if (f <= fArray[n9 + n5]) {
                                n2 = n9;
                                continue;
                            }
                            n10 = n9 + 1;
                        }
                    } else {
                        if (n6 <= n8) break;
                        n = n4;
                        n2 = n6 >>> 1;
                        f = fArray[n2 + n5];
                        n10 = 0;
                        while (n10 < n) {
                            n9 = n10 + n >>> 1;
                            if (f <= fArray[n9 + n3]) {
                                n = n9;
                                continue;
                            }
                            n10 = n9 + 1;
                        }
                    }
                    Merger merger = new Merger(this, fArray, fArray2, n3 + n, n4 - n, n5 + n2, n6 - n2, n7 + n + n2, n8);
                    n6 = n2;
                    n4 = n;
                    this.addToPendingCount(1);
                    merger.fork();
                }
                n = n3 + n4;
                n2 = n5 + n6;
                while (n3 < n && n5 < n2) {
                    float f;
                    float f2;
                    float f3;
                    float f4 = fArray[n3];
                    float f5 = fArray[n5];
                    if (f3 <= f2) {
                        ++n3;
                        f = f4;
                    } else {
                        ++n5;
                        f = f5;
                    }
                    fArray2[n7++] = f;
                }
                if (n5 < n2) {
                    System.arraycopy(fArray, n5, fArray2, n7, n2 - n5);
                } else if (n3 < n) {
                    System.arraycopy(fArray, n3, fArray2, n7, n - n3);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final float[] a;
            final float[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> countedCompleter, float[] fArray, float[] fArray2, int n, int n2, int n3, int n4) {
                super(countedCompleter);
                this.a = fArray;
                this.w = fArray2;
                this.base = n;
                this.size = n2;
                this.wbase = n3;
                this.gran = n4;
            }

            @Override
            public final void compute() {
                CountedCompleter countedCompleter = this;
                float[] fArray = this.a;
                float[] fArray2 = this.w;
                int n = this.base;
                int n2 = this.size;
                int n3 = this.wbase;
                int n4 = this.gran;
                while (n2 > n4) {
                    int n5 = n2 >>> 1;
                    int n6 = n5 >>> 1;
                    int n7 = n5 + n6;
                    Relay relay = new Relay(new Merger(countedCompleter, fArray2, fArray, n3, n5, n3 + n5, n2 - n5, n, n4));
                    Relay relay2 = new Relay(new Merger(relay, fArray, fArray2, n + n5, n6, n + n7, n2 - n7, n3 + n5, n4));
                    new Sorter(relay2, fArray, fArray2, n + n7, n2 - n7, n3 + n7, n4).fork();
                    new Sorter(relay2, fArray, fArray2, n + n5, n6, n3 + n5, n4).fork();
                    Relay relay3 = new Relay(new Merger(relay, fArray, fArray2, n, n6, n + n6, n5 - n6, n3, n4));
                    new Sorter(relay3, fArray, fArray2, n + n6, n5 - n6, n3 + n6, n4).fork();
                    countedCompleter = new EmptyCompleter(relay3);
                    n2 = n6;
                }
                DualPivotQuicksort.sort(fArray, n, n + n2 - 1, fArray2, n3, n2);
                countedCompleter.tryComplete();
            }
        }
    }

    static final class FJLong {
        FJLong() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final long[] a;
            final long[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> countedCompleter, long[] lArray, long[] lArray2, int n, int n2, int n3, int n4, int n5, int n6) {
                super(countedCompleter);
                this.a = lArray;
                this.w = lArray2;
                this.lbase = n;
                this.lsize = n2;
                this.rbase = n3;
                this.rsize = n4;
                this.wbase = n5;
                this.gran = n6;
            }

            @Override
            public final void compute() {
                int n;
                int n2;
                long[] lArray = this.a;
                long[] lArray2 = this.w;
                int n3 = this.lbase;
                int n4 = this.lsize;
                int n5 = this.rbase;
                int n6 = this.rsize;
                int n7 = this.wbase;
                int n8 = this.gran;
                if (lArray == null || lArray2 == null || n3 < 0 || n5 < 0 || n7 < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int n9;
                    int n10;
                    long l;
                    if (n4 >= n6) {
                        if (n4 <= n8) break;
                        n2 = n6;
                        n = n4 >>> 1;
                        l = lArray[n + n3];
                        n10 = 0;
                        while (n10 < n2) {
                            n9 = n10 + n2 >>> 1;
                            if (l <= lArray[n9 + n5]) {
                                n2 = n9;
                                continue;
                            }
                            n10 = n9 + 1;
                        }
                    } else {
                        if (n6 <= n8) break;
                        n = n4;
                        n2 = n6 >>> 1;
                        l = lArray[n2 + n5];
                        n10 = 0;
                        while (n10 < n) {
                            n9 = n10 + n >>> 1;
                            if (l <= lArray[n9 + n3]) {
                                n = n9;
                                continue;
                            }
                            n10 = n9 + 1;
                        }
                    }
                    Merger merger = new Merger(this, lArray, lArray2, n3 + n, n4 - n, n5 + n2, n6 - n2, n7 + n + n2, n8);
                    n6 = n2;
                    n4 = n;
                    this.addToPendingCount(1);
                    merger.fork();
                }
                n = n3 + n4;
                n2 = n5 + n6;
                while (n3 < n && n5 < n2) {
                    long l;
                    long l2 = lArray[n3];
                    long l3 = lArray[n5];
                    if (l2 <= l3) {
                        ++n3;
                        l = l2;
                    } else {
                        ++n5;
                        l = l3;
                    }
                    lArray2[n7++] = l;
                }
                if (n5 < n2) {
                    System.arraycopy(lArray, n5, lArray2, n7, n2 - n5);
                } else if (n3 < n) {
                    System.arraycopy(lArray, n3, lArray2, n7, n - n3);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final long[] a;
            final long[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> countedCompleter, long[] lArray, long[] lArray2, int n, int n2, int n3, int n4) {
                super(countedCompleter);
                this.a = lArray;
                this.w = lArray2;
                this.base = n;
                this.size = n2;
                this.wbase = n3;
                this.gran = n4;
            }

            @Override
            public final void compute() {
                CountedCompleter countedCompleter = this;
                long[] lArray = this.a;
                long[] lArray2 = this.w;
                int n = this.base;
                int n2 = this.size;
                int n3 = this.wbase;
                int n4 = this.gran;
                while (n2 > n4) {
                    int n5 = n2 >>> 1;
                    int n6 = n5 >>> 1;
                    int n7 = n5 + n6;
                    Relay relay = new Relay(new Merger(countedCompleter, lArray2, lArray, n3, n5, n3 + n5, n2 - n5, n, n4));
                    Relay relay2 = new Relay(new Merger(relay, lArray, lArray2, n + n5, n6, n + n7, n2 - n7, n3 + n5, n4));
                    new Sorter(relay2, lArray, lArray2, n + n7, n2 - n7, n3 + n7, n4).fork();
                    new Sorter(relay2, lArray, lArray2, n + n5, n6, n3 + n5, n4).fork();
                    Relay relay3 = new Relay(new Merger(relay, lArray, lArray2, n, n6, n + n6, n5 - n6, n3, n4));
                    new Sorter(relay3, lArray, lArray2, n + n6, n5 - n6, n3 + n6, n4).fork();
                    countedCompleter = new EmptyCompleter(relay3);
                    n2 = n6;
                }
                DualPivotQuicksort.sort(lArray, n, n + n2 - 1, lArray2, n3, n2);
                countedCompleter.tryComplete();
            }
        }
    }

    static final class FJInt {
        FJInt() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final int[] a;
            final int[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> countedCompleter, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6) {
                super(countedCompleter);
                this.a = nArray;
                this.w = nArray2;
                this.lbase = n;
                this.lsize = n2;
                this.rbase = n3;
                this.rsize = n4;
                this.wbase = n5;
                this.gran = n6;
            }

            @Override
            public final void compute() {
                int n;
                int n2;
                int n3;
                int n4;
                int[] nArray = this.a;
                int[] nArray2 = this.w;
                int n5 = this.lbase;
                int n6 = this.lsize;
                int n7 = this.rbase;
                int n8 = this.rsize;
                int n9 = this.wbase;
                int n10 = this.gran;
                if (nArray == null || nArray2 == null || n5 < 0 || n7 < 0 || n9 < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int n11;
                    if (n6 >= n8) {
                        if (n6 <= n10) break;
                        n4 = n8;
                        n3 = n6 >>> 1;
                        n11 = nArray[n3 + n5];
                        n2 = 0;
                        while (n2 < n4) {
                            n = n2 + n4 >>> 1;
                            if (n11 <= nArray[n + n7]) {
                                n4 = n;
                                continue;
                            }
                            n2 = n + 1;
                        }
                    } else {
                        if (n8 <= n10) break;
                        n3 = n6;
                        n4 = n8 >>> 1;
                        n11 = nArray[n4 + n7];
                        n2 = 0;
                        while (n2 < n3) {
                            n = n2 + n3 >>> 1;
                            if (n11 <= nArray[n + n5]) {
                                n3 = n;
                                continue;
                            }
                            n2 = n + 1;
                        }
                    }
                    Merger merger = new Merger(this, nArray, nArray2, n5 + n3, n6 - n3, n7 + n4, n8 - n4, n9 + n3 + n4, n10);
                    n8 = n4;
                    n6 = n3;
                    this.addToPendingCount(1);
                    merger.fork();
                }
                n3 = n5 + n6;
                n4 = n7 + n8;
                while (n5 < n3 && n7 < n4) {
                    int n12;
                    n2 = nArray[n5];
                    n = nArray[n7];
                    if (n2 <= n) {
                        ++n5;
                        n12 = n2;
                    } else {
                        ++n7;
                        n12 = n;
                    }
                    nArray2[n9++] = n12;
                }
                if (n7 < n4) {
                    System.arraycopy(nArray, n7, nArray2, n9, n4 - n7);
                } else if (n5 < n3) {
                    System.arraycopy(nArray, n5, nArray2, n9, n3 - n5);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final int[] a;
            final int[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> countedCompleter, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
                super(countedCompleter);
                this.a = nArray;
                this.w = nArray2;
                this.base = n;
                this.size = n2;
                this.wbase = n3;
                this.gran = n4;
            }

            @Override
            public final void compute() {
                CountedCompleter countedCompleter = this;
                int[] nArray = this.a;
                int[] nArray2 = this.w;
                int n = this.base;
                int n2 = this.size;
                int n3 = this.wbase;
                int n4 = this.gran;
                while (n2 > n4) {
                    int n5 = n2 >>> 1;
                    int n6 = n5 >>> 1;
                    int n7 = n5 + n6;
                    Relay relay = new Relay(new Merger(countedCompleter, nArray2, nArray, n3, n5, n3 + n5, n2 - n5, n, n4));
                    Relay relay2 = new Relay(new Merger(relay, nArray, nArray2, n + n5, n6, n + n7, n2 - n7, n3 + n5, n4));
                    new Sorter(relay2, nArray, nArray2, n + n7, n2 - n7, n3 + n7, n4).fork();
                    new Sorter(relay2, nArray, nArray2, n + n5, n6, n3 + n5, n4).fork();
                    Relay relay3 = new Relay(new Merger(relay, nArray, nArray2, n, n6, n + n6, n5 - n6, n3, n4));
                    new Sorter(relay3, nArray, nArray2, n + n6, n5 - n6, n3 + n6, n4).fork();
                    countedCompleter = new EmptyCompleter(relay3);
                    n2 = n6;
                }
                DualPivotQuicksort.sort(nArray, n, n + n2 - 1, nArray2, n3, n2);
                countedCompleter.tryComplete();
            }
        }
    }

    static final class FJShort {
        FJShort() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final short[] a;
            final short[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> countedCompleter, short[] sArray, short[] sArray2, int n, int n2, int n3, int n4, int n5, int n6) {
                super(countedCompleter);
                this.a = sArray;
                this.w = sArray2;
                this.lbase = n;
                this.lsize = n2;
                this.rbase = n3;
                this.rsize = n4;
                this.wbase = n5;
                this.gran = n6;
            }

            @Override
            public final void compute() {
                int n;
                int n2;
                int n3;
                int n4;
                short[] sArray = this.a;
                short[] sArray2 = this.w;
                int n5 = this.lbase;
                int n6 = this.lsize;
                int n7 = this.rbase;
                int n8 = this.rsize;
                int n9 = this.wbase;
                int n10 = this.gran;
                if (sArray == null || sArray2 == null || n5 < 0 || n7 < 0 || n9 < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    short s;
                    if (n6 >= n8) {
                        if (n6 <= n10) break;
                        n4 = n8;
                        n3 = n6 >>> 1;
                        s = sArray[n3 + n5];
                        n2 = 0;
                        while (n2 < n4) {
                            n = n2 + n4 >>> 1;
                            if (s <= sArray[n + n7]) {
                                n4 = n;
                                continue;
                            }
                            n2 = n + 1;
                        }
                    } else {
                        if (n8 <= n10) break;
                        n3 = n6;
                        n4 = n8 >>> 1;
                        s = sArray[n4 + n7];
                        n2 = 0;
                        while (n2 < n3) {
                            n = n2 + n3 >>> 1;
                            if (s <= sArray[n + n5]) {
                                n3 = n;
                                continue;
                            }
                            n2 = n + 1;
                        }
                    }
                    Merger merger = new Merger(this, sArray, sArray2, n5 + n3, n6 - n3, n7 + n4, n8 - n4, n9 + n3 + n4, n10);
                    n8 = n4;
                    n6 = n3;
                    this.addToPendingCount(1);
                    merger.fork();
                }
                n3 = n5 + n6;
                n4 = n7 + n8;
                while (n5 < n3 && n7 < n4) {
                    int n11;
                    n2 = sArray[n5];
                    n = sArray[n7];
                    if (n2 <= n) {
                        ++n5;
                        n11 = n2;
                    } else {
                        ++n7;
                        n11 = n;
                    }
                    sArray2[n9++] = n11;
                }
                if (n7 < n4) {
                    System.arraycopy(sArray, n7, sArray2, n9, n4 - n7);
                } else if (n5 < n3) {
                    System.arraycopy(sArray, n5, sArray2, n9, n3 - n5);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final short[] a;
            final short[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> countedCompleter, short[] sArray, short[] sArray2, int n, int n2, int n3, int n4) {
                super(countedCompleter);
                this.a = sArray;
                this.w = sArray2;
                this.base = n;
                this.size = n2;
                this.wbase = n3;
                this.gran = n4;
            }

            @Override
            public final void compute() {
                CountedCompleter countedCompleter = this;
                short[] sArray = this.a;
                short[] sArray2 = this.w;
                int n = this.base;
                int n2 = this.size;
                int n3 = this.wbase;
                int n4 = this.gran;
                while (n2 > n4) {
                    int n5 = n2 >>> 1;
                    int n6 = n5 >>> 1;
                    int n7 = n5 + n6;
                    Relay relay = new Relay(new Merger(countedCompleter, sArray2, sArray, n3, n5, n3 + n5, n2 - n5, n, n4));
                    Relay relay2 = new Relay(new Merger(relay, sArray, sArray2, n + n5, n6, n + n7, n2 - n7, n3 + n5, n4));
                    new Sorter(relay2, sArray, sArray2, n + n7, n2 - n7, n3 + n7, n4).fork();
                    new Sorter(relay2, sArray, sArray2, n + n5, n6, n3 + n5, n4).fork();
                    Relay relay3 = new Relay(new Merger(relay, sArray, sArray2, n, n6, n + n6, n5 - n6, n3, n4));
                    new Sorter(relay3, sArray, sArray2, n + n6, n5 - n6, n3 + n6, n4).fork();
                    countedCompleter = new EmptyCompleter(relay3);
                    n2 = n6;
                }
                DualPivotQuicksort.sort(sArray, n, n + n2 - 1, sArray2, n3, n2);
                countedCompleter.tryComplete();
            }
        }
    }

    static final class FJChar {
        FJChar() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final char[] a;
            final char[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> countedCompleter, char[] cArray, char[] cArray2, int n, int n2, int n3, int n4, int n5, int n6) {
                super(countedCompleter);
                this.a = cArray;
                this.w = cArray2;
                this.lbase = n;
                this.lsize = n2;
                this.rbase = n3;
                this.rsize = n4;
                this.wbase = n5;
                this.gran = n6;
            }

            @Override
            public final void compute() {
                int n;
                int n2;
                int n3;
                int n4;
                char[] cArray = this.a;
                char[] cArray2 = this.w;
                int n5 = this.lbase;
                int n6 = this.lsize;
                int n7 = this.rbase;
                int n8 = this.rsize;
                int n9 = this.wbase;
                int n10 = this.gran;
                if (cArray == null || cArray2 == null || n5 < 0 || n7 < 0 || n9 < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    char c;
                    if (n6 >= n8) {
                        if (n6 <= n10) break;
                        n4 = n8;
                        n3 = n6 >>> 1;
                        c = cArray[n3 + n5];
                        n2 = 0;
                        while (n2 < n4) {
                            n = n2 + n4 >>> 1;
                            if (c <= cArray[n + n7]) {
                                n4 = n;
                                continue;
                            }
                            n2 = n + 1;
                        }
                    } else {
                        if (n8 <= n10) break;
                        n3 = n6;
                        n4 = n8 >>> 1;
                        c = cArray[n4 + n7];
                        n2 = 0;
                        while (n2 < n3) {
                            n = n2 + n3 >>> 1;
                            if (c <= cArray[n + n5]) {
                                n3 = n;
                                continue;
                            }
                            n2 = n + 1;
                        }
                    }
                    Merger merger = new Merger(this, cArray, cArray2, n5 + n3, n6 - n3, n7 + n4, n8 - n4, n9 + n3 + n4, n10);
                    n8 = n4;
                    n6 = n3;
                    this.addToPendingCount(1);
                    merger.fork();
                }
                n3 = n5 + n6;
                n4 = n7 + n8;
                while (n5 < n3 && n7 < n4) {
                    int n11;
                    n2 = cArray[n5];
                    n = cArray[n7];
                    if (n2 <= n) {
                        ++n5;
                        n11 = n2;
                    } else {
                        ++n7;
                        n11 = n;
                    }
                    cArray2[n9++] = n11;
                }
                if (n7 < n4) {
                    System.arraycopy(cArray, n7, cArray2, n9, n4 - n7);
                } else if (n5 < n3) {
                    System.arraycopy(cArray, n5, cArray2, n9, n3 - n5);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final char[] a;
            final char[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> countedCompleter, char[] cArray, char[] cArray2, int n, int n2, int n3, int n4) {
                super(countedCompleter);
                this.a = cArray;
                this.w = cArray2;
                this.base = n;
                this.size = n2;
                this.wbase = n3;
                this.gran = n4;
            }

            @Override
            public final void compute() {
                CountedCompleter countedCompleter = this;
                char[] cArray = this.a;
                char[] cArray2 = this.w;
                int n = this.base;
                int n2 = this.size;
                int n3 = this.wbase;
                int n4 = this.gran;
                while (n2 > n4) {
                    int n5 = n2 >>> 1;
                    int n6 = n5 >>> 1;
                    int n7 = n5 + n6;
                    Relay relay = new Relay(new Merger(countedCompleter, cArray2, cArray, n3, n5, n3 + n5, n2 - n5, n, n4));
                    Relay relay2 = new Relay(new Merger(relay, cArray, cArray2, n + n5, n6, n + n7, n2 - n7, n3 + n5, n4));
                    new Sorter(relay2, cArray, cArray2, n + n7, n2 - n7, n3 + n7, n4).fork();
                    new Sorter(relay2, cArray, cArray2, n + n5, n6, n3 + n5, n4).fork();
                    Relay relay3 = new Relay(new Merger(relay, cArray, cArray2, n, n6, n + n6, n5 - n6, n3, n4));
                    new Sorter(relay3, cArray, cArray2, n + n6, n5 - n6, n3 + n6, n4).fork();
                    countedCompleter = new EmptyCompleter(relay3);
                    n2 = n6;
                }
                DualPivotQuicksort.sort(cArray, n, n + n2 - 1, cArray2, n3, n2);
                countedCompleter.tryComplete();
            }
        }
    }

    static final class FJByte {
        FJByte() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final byte[] a;
            final byte[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> countedCompleter, byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, int n5, int n6) {
                super(countedCompleter);
                this.a = byArray;
                this.w = byArray2;
                this.lbase = n;
                this.lsize = n2;
                this.rbase = n3;
                this.rsize = n4;
                this.wbase = n5;
                this.gran = n6;
            }

            @Override
            public final void compute() {
                int n;
                int n2;
                int n3;
                int n4;
                byte[] byArray = this.a;
                byte[] byArray2 = this.w;
                int n5 = this.lbase;
                int n6 = this.lsize;
                int n7 = this.rbase;
                int n8 = this.rsize;
                int n9 = this.wbase;
                int n10 = this.gran;
                if (byArray == null || byArray2 == null || n5 < 0 || n7 < 0 || n9 < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    byte by;
                    if (n6 >= n8) {
                        if (n6 <= n10) break;
                        n4 = n8;
                        n3 = n6 >>> 1;
                        by = byArray[n3 + n5];
                        n2 = 0;
                        while (n2 < n4) {
                            n = n2 + n4 >>> 1;
                            if (by <= byArray[n + n7]) {
                                n4 = n;
                                continue;
                            }
                            n2 = n + 1;
                        }
                    } else {
                        if (n8 <= n10) break;
                        n3 = n6;
                        n4 = n8 >>> 1;
                        by = byArray[n4 + n7];
                        n2 = 0;
                        while (n2 < n3) {
                            n = n2 + n3 >>> 1;
                            if (by <= byArray[n + n5]) {
                                n3 = n;
                                continue;
                            }
                            n2 = n + 1;
                        }
                    }
                    Merger merger = new Merger(this, byArray, byArray2, n5 + n3, n6 - n3, n7 + n4, n8 - n4, n9 + n3 + n4, n10);
                    n8 = n4;
                    n6 = n3;
                    this.addToPendingCount(1);
                    merger.fork();
                }
                n3 = n5 + n6;
                n4 = n7 + n8;
                while (n5 < n3 && n7 < n4) {
                    int n11;
                    n2 = byArray[n5];
                    n = byArray[n7];
                    if (n2 <= n) {
                        ++n5;
                        n11 = n2;
                    } else {
                        ++n7;
                        n11 = n;
                    }
                    byArray2[n9++] = n11;
                }
                if (n7 < n4) {
                    System.arraycopy(byArray, n7, byArray2, n9, n4 - n7);
                } else if (n5 < n3) {
                    System.arraycopy(byArray, n5, byArray2, n9, n3 - n5);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final byte[] a;
            final byte[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> countedCompleter, byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
                super(countedCompleter);
                this.a = byArray;
                this.w = byArray2;
                this.base = n;
                this.size = n2;
                this.wbase = n3;
                this.gran = n4;
            }

            @Override
            public final void compute() {
                CountedCompleter countedCompleter = this;
                byte[] byArray = this.a;
                byte[] byArray2 = this.w;
                int n = this.base;
                int n2 = this.size;
                int n3 = this.wbase;
                int n4 = this.gran;
                while (n2 > n4) {
                    int n5 = n2 >>> 1;
                    int n6 = n5 >>> 1;
                    int n7 = n5 + n6;
                    Relay relay = new Relay(new Merger(countedCompleter, byArray2, byArray, n3, n5, n3 + n5, n2 - n5, n, n4));
                    Relay relay2 = new Relay(new Merger(relay, byArray, byArray2, n + n5, n6, n + n7, n2 - n7, n3 + n5, n4));
                    new Sorter(relay2, byArray, byArray2, n + n7, n2 - n7, n3 + n7, n4).fork();
                    new Sorter(relay2, byArray, byArray2, n + n5, n6, n3 + n5, n4).fork();
                    Relay relay3 = new Relay(new Merger(relay, byArray, byArray2, n, n6, n + n6, n5 - n6, n3, n4));
                    new Sorter(relay3, byArray, byArray2, n + n6, n5 - n6, n3 + n6, n4).fork();
                    countedCompleter = new EmptyCompleter(relay3);
                    n2 = n6;
                }
                DualPivotQuicksort.sort(byArray, n, n + n2 - 1);
                countedCompleter.tryComplete();
            }
        }
    }

    static final class FJObject {
        FJObject() {
        }

        static final class Merger<T>
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final T[] a;
            final T[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;
            Comparator<? super T> comparator;

            Merger(CountedCompleter<?> countedCompleter, T[] TArray, T[] TArray2, int n, int n2, int n3, int n4, int n5, int n6, Comparator<? super T> comparator) {
                super(countedCompleter);
                this.a = TArray;
                this.w = TArray2;
                this.lbase = n;
                this.lsize = n2;
                this.rbase = n3;
                this.rsize = n4;
                this.wbase = n5;
                this.gran = n6;
                this.comparator = comparator;
            }

            @Override
            public final void compute() {
                Object object;
                int n;
                int n2;
                Comparator<T> comparator = this.comparator;
                T[] TArray = this.a;
                T[] TArray2 = this.w;
                int n3 = this.lbase;
                int n4 = this.lsize;
                int n5 = this.rbase;
                int n6 = this.rsize;
                int n7 = this.wbase;
                int n8 = this.gran;
                if (TArray == null || TArray2 == null || n3 < 0 || n5 < 0 || n7 < 0 || comparator == null) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int n9;
                    int n10;
                    if (n4 >= n6) {
                        if (n4 <= n8) break;
                        n2 = n6;
                        n = n4 >>> 1;
                        object = TArray[n + n3];
                        n10 = 0;
                        while (n10 < n2) {
                            n9 = n10 + n2 >>> 1;
                            if (comparator.compare(object, TArray[n9 + n5]) <= 0) {
                                n2 = n9;
                                continue;
                            }
                            n10 = n9 + 1;
                        }
                    } else {
                        if (n6 <= n8) break;
                        n = n4;
                        n2 = n6 >>> 1;
                        object = TArray[n2 + n5];
                        n10 = 0;
                        while (n10 < n) {
                            n9 = n10 + n >>> 1;
                            if (comparator.compare(object, TArray[n9 + n3]) <= 0) {
                                n = n9;
                                continue;
                            }
                            n10 = n9 + 1;
                        }
                    }
                    object = new Merger<T>(this, TArray, TArray2, n3 + n, n4 - n, n5 + n2, n6 - n2, n7 + n + n2, n8, comparator);
                    n6 = n2;
                    n4 = n;
                    this.addToPendingCount(1);
                    ((ForkJoinTask)object).fork();
                }
                n = n3 + n4;
                n2 = n5 + n6;
                while (n3 < n && n5 < n2) {
                    T t = TArray[n3];
                    T t2 = TArray[n5];
                    if (comparator.compare(t, t2) <= 0) {
                        ++n3;
                        object = t;
                    } else {
                        ++n5;
                        object = t2;
                    }
                    TArray2[n7++] = object;
                }
                if (n5 < n2) {
                    System.arraycopy(TArray, n5, TArray2, n7, n2 - n5);
                } else if (n3 < n) {
                    System.arraycopy(TArray, n3, TArray2, n7, n - n3);
                }
                this.tryComplete();
            }
        }

        static final class Sorter<T>
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final T[] a;
            final T[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;
            Comparator<? super T> comparator;

            Sorter(CountedCompleter<?> countedCompleter, T[] TArray, T[] TArray2, int n, int n2, int n3, int n4, Comparator<? super T> comparator) {
                super(countedCompleter);
                this.a = TArray;
                this.w = TArray2;
                this.base = n;
                this.size = n2;
                this.wbase = n3;
                this.gran = n4;
                this.comparator = comparator;
            }

            @Override
            public final void compute() {
                CountedCompleter countedCompleter = this;
                Comparator<? super T> comparator = this.comparator;
                T[] TArray = this.a;
                T[] TArray2 = this.w;
                int n = this.base;
                int n2 = this.size;
                int n3 = this.wbase;
                int n4 = this.gran;
                while (n2 > n4) {
                    int n5 = n2 >>> 1;
                    int n6 = n5 >>> 1;
                    int n7 = n5 + n6;
                    Relay relay = new Relay(new Merger<T>(countedCompleter, TArray2, TArray, n3, n5, n3 + n5, n2 - n5, n, n4, comparator));
                    Relay relay2 = new Relay(new Merger<T>(relay, TArray, TArray2, n + n5, n6, n + n7, n2 - n7, n3 + n5, n4, comparator));
                    new Sorter<T>(relay2, TArray, TArray2, n + n7, n2 - n7, n3 + n7, n4, comparator).fork();
                    new Sorter<T>(relay2, TArray, TArray2, n + n5, n6, n3 + n5, n4, comparator).fork();
                    Relay relay3 = new Relay(new Merger<T>(relay, TArray, TArray2, n, n6, n + n6, n5 - n6, n3, n4, comparator));
                    new Sorter<T>(relay3, TArray, TArray2, n + n6, n5 - n6, n3 + n6, n4, comparator).fork();
                    countedCompleter = new EmptyCompleter(relay3);
                    n2 = n6;
                }
                TimSort.sort(TArray, n, n + n2, comparator, TArray2, n3, n2);
                countedCompleter.tryComplete();
            }
        }
    }

    static final class Relay
    extends CountedCompleter<Void> {
        static final long serialVersionUID = 2446542900576103244L;
        final CountedCompleter<?> task;

        Relay(CountedCompleter<?> countedCompleter) {
            super(null, 1);
            this.task = countedCompleter;
        }

        @Override
        public final void compute() {
        }

        @Override
        public final void onCompletion(CountedCompleter<?> countedCompleter) {
            this.task.compute();
        }
    }

    static final class EmptyCompleter
    extends CountedCompleter<Void> {
        static final long serialVersionUID = 2446542900576103244L;

        EmptyCompleter(CountedCompleter<?> countedCompleter) {
            super(countedCompleter);
        }

        @Override
        public final void compute() {
        }
    }
}

