/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sun.font.CCharToGlyphMapper;
import sun.font.CStrike;
import sun.font.CharToGlyphMapper;
import sun.font.Font2DHandle;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.PhysicalFont;
import sun.font.StrikeMetrics;

public final class CFont
extends PhysicalFont {
    private boolean isFakeItalic;
    private String nativeFontName;
    private long nativeFontPtr;
    private static FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);

    @Override
    StrikeMetrics getFontMetrics(long l) {
        throw new InternalError("Not implemented");
    }

    @Override
    float getGlyphAdvance(long l, int n) {
        throw new InternalError("Not implemented");
    }

    @Override
    void getGlyphMetrics(long l, int n, Point2D.Float float_) {
        throw new InternalError("Not implemented");
    }

    @Override
    long getGlyphImage(long l, int n) {
        throw new InternalError("Not implemented");
    }

    @Override
    Rectangle2D.Float getGlyphOutlineBounds(long l, int n) {
        throw new InternalError("Not implemented");
    }

    @Override
    GeneralPath getGlyphOutline(long l, int n, float f, float f2) {
        throw new InternalError("Not implemented");
    }

    @Override
    GeneralPath getGlyphVectorOutline(long l, int[] nArray, int n, float f, float f2) {
        throw new InternalError("Not implemented");
    }

    private static native long createNativeFont(String var0, int var1, boolean var2);

    private static native void disposeNativeFont(long var0);

    public CFont(String string) {
        this(string, string);
    }

    public CFont(String string, String string2) {
        this.handle = new Font2DHandle(this);
        this.fullName = string;
        this.familyName = string2;
        this.nativeFontName = string2;
        this.setStyle();
    }

    public CFont(CFont cFont, String string) {
        this.handle = new Font2DHandle(this);
        this.fullName = string;
        this.familyName = string;
        this.nativeFontName = cFont.nativeFontName;
        this.style = cFont.style;
        this.isFakeItalic = cFont.isFakeItalic;
    }

    public CFont createItalicVariant() {
        CFont cFont = new CFont(this, this.familyName);
        cFont.fullName = this.fullName + (this.style == 1 ? "" : "-") + "Italic-Derived";
        cFont.style |= 2;
        cFont.isFakeItalic = true;
        return cFont;
    }

    protected synchronized long getNativeFontPtr() {
        if (this.nativeFontPtr == 0L) {
            this.nativeFontPtr = CFont.createNativeFont(this.nativeFontName, this.style, this.isFakeItalic);
        }
        return this.nativeFontPtr;
    }

    protected synchronized void finalize() {
        if (this.nativeFontPtr != 0L) {
            CFont.disposeNativeFont(this.nativeFontPtr);
        }
        this.nativeFontPtr = 0L;
    }

    @Override
    protected CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new CCharToGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    protected FontStrike createStrike(FontStrikeDesc fontStrikeDesc) {
        if (this.isFakeItalic) {
            fontStrikeDesc = new FontStrikeDesc(fontStrikeDesc);
            fontStrikeDesc.glyphTx.concatenate(AffineTransform.getShearInstance(-0.2, 0.0));
        }
        return new CStrike(this, fontStrikeDesc);
    }

    @Override
    public FontStrike getStrike(Font font) {
        return this.getStrike(font, DEFAULT_FRC);
    }

    public String toString() {
        return "CFont { fullName: " + this.fullName + ",  familyName: " + this.familyName + ", style: " + this.style + " } aka: " + super.toString();
    }
}

