/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import com.sun.media.sound.DataPusher;
import com.sun.media.sound.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import sun.audio.AudioDataStream;
import sun.audio.AudioStream;
import sun.audio.ContinuousAudioDataStream;

public final class AudioDevice {
    private boolean DEBUG = false;
    private Hashtable clipStreams = new Hashtable();
    private Vector infos = new Vector();
    private boolean playing = false;
    private Mixer mixer = null;
    public static final AudioDevice device = new AudioDevice();

    private AudioDevice() {
    }

    private synchronized void startSampled(AudioInputStream audioInputStream, InputStream inputStream) throws UnsupportedAudioFileException, LineUnavailableException {
        Info info = null;
        DataPusher dataPusher = null;
        DataLine.Info info2 = null;
        SourceDataLine sourceDataLine = null;
        if ((audioInputStream = Toolkit.getPCMConvertedAudioInputStream(audioInputStream)) == null) {
            return;
        }
        info2 = new DataLine.Info(SourceDataLine.class, audioInputStream.getFormat());
        if (!AudioSystem.isLineSupported(info2)) {
            return;
        }
        sourceDataLine = (SourceDataLine)AudioSystem.getLine(info2);
        dataPusher = new DataPusher(sourceDataLine, audioInputStream);
        info = new Info(null, inputStream, dataPusher);
        this.infos.addElement(info);
        dataPusher.start();
    }

    private synchronized void startMidi(InputStream inputStream, InputStream inputStream2) throws InvalidMidiDataException, MidiUnavailableException {
        Sequencer sequencer = null;
        Info info = null;
        sequencer = MidiSystem.getSequencer();
        sequencer.open();
        try {
            sequencer.setSequence(inputStream);
        }
        catch (IOException iOException) {
            throw new InvalidMidiDataException(iOException.getMessage());
        }
        info = new Info(sequencer, inputStream2, null);
        this.infos.addElement(info);
        sequencer.addMetaEventListener(info);
        sequencer.start();
    }

    public synchronized void openChannel(InputStream inputStream) {
        if (this.DEBUG) {
            System.out.println("AudioDevice: openChannel");
            System.out.println("input stream =" + inputStream);
        }
        Info info = null;
        for (int i = 0; i < this.infos.size(); ++i) {
            info = (Info)this.infos.elementAt(i);
            if (info.in != inputStream) continue;
            return;
        }
        AudioInputStream audioInputStream = null;
        if (inputStream instanceof AudioStream) {
            if (((AudioStream)inputStream).midiformat != null) {
                try {
                    this.startMidi(((AudioStream)inputStream).stream, inputStream);
                }
                catch (Exception exception) {
                    return;
                }
            } else if (((AudioStream)inputStream).ais != null) {
                try {
                    this.startSampled(((AudioStream)inputStream).ais, inputStream);
                }
                catch (Exception exception) {
                    return;
                }
            }
        } else if (inputStream instanceof AudioDataStream) {
            if (inputStream instanceof ContinuousAudioDataStream) {
                try {
                    AudioInputStream audioInputStream2 = new AudioInputStream(inputStream, ((AudioDataStream)inputStream).getAudioData().format, -1L);
                    this.startSampled(audioInputStream2, inputStream);
                }
                catch (Exception exception) {
                    return;
                }
            } else {
                try {
                    AudioInputStream audioInputStream3 = new AudioInputStream(inputStream, ((AudioDataStream)inputStream).getAudioData().format, ((AudioDataStream)inputStream).getAudioData().buffer.length);
                    this.startSampled(audioInputStream3, inputStream);
                }
                catch (Exception exception) {
                    return;
                }
            }
        } else {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 1024);
            try {
                try {
                    audioInputStream = AudioSystem.getAudioInputStream(bufferedInputStream);
                }
                catch (IOException iOException) {
                    return;
                }
                this.startSampled(audioInputStream, inputStream);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                try {
                    try {
                        MidiFileFormat midiFileFormat = MidiSystem.getMidiFileFormat(bufferedInputStream);
                    }
                    catch (IOException iOException) {
                        return;
                    }
                    this.startMidi(bufferedInputStream, inputStream);
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.ULAW, 8000.0f, 8, 1, 1, 8000.0f, true);
                    try {
                        AudioInputStream audioInputStream4 = new AudioInputStream(bufferedInputStream, audioFormat, -1L);
                        this.startSampled(audioInputStream4, inputStream);
                    }
                    catch (UnsupportedAudioFileException unsupportedAudioFileException2) {
                        return;
                    }
                    catch (LineUnavailableException lineUnavailableException) {
                        return;
                    }
                }
                catch (MidiUnavailableException midiUnavailableException) {
                    return;
                }
            }
            catch (LineUnavailableException lineUnavailableException) {
                return;
            }
        }
        this.notify();
    }

    public synchronized void closeChannel(InputStream inputStream) {
        if (this.DEBUG) {
            System.out.println("AudioDevice.closeChannel");
        }
        if (inputStream == null) {
            return;
        }
        for (int i = 0; i < this.infos.size(); ++i) {
            Info info = (Info)this.infos.elementAt(i);
            if (info.in != inputStream) continue;
            if (info.sequencer != null) {
                info.sequencer.stop();
                this.infos.removeElement(info);
                continue;
            }
            if (info.datapusher == null) continue;
            info.datapusher.stop();
            this.infos.removeElement(info);
        }
        this.notify();
    }

    public synchronized void open() {
    }

    public synchronized void close() {
    }

    public void play() {
        if (this.DEBUG) {
            System.out.println("exiting play()");
        }
    }

    public synchronized void closeStreams() {
        for (int i = 0; i < this.infos.size(); ++i) {
            Info info = (Info)this.infos.elementAt(i);
            if (info.sequencer != null) {
                info.sequencer.stop();
                info.sequencer.close();
                this.infos.removeElement(info);
                continue;
            }
            if (info.datapusher == null) continue;
            info.datapusher.stop();
            this.infos.removeElement(info);
        }
        if (this.DEBUG) {
            System.err.println("Audio Device: Streams all closed.");
        }
        this.clipStreams = new Hashtable();
        this.infos = new Vector();
    }

    public int openChannels() {
        return this.infos.size();
    }

    void setVerbose(boolean bl) {
        this.DEBUG = bl;
    }

    final class Info
    implements MetaEventListener {
        final Sequencer sequencer;
        final InputStream in;
        final DataPusher datapusher;

        Info(Sequencer sequencer, InputStream inputStream, DataPusher dataPusher) {
            this.sequencer = sequencer;
            this.in = inputStream;
            this.datapusher = dataPusher;
        }

        @Override
        public void meta(MetaMessage metaMessage) {
            if (metaMessage.getType() == 47 && this.sequencer != null) {
                this.sequencer.close();
            }
        }
    }
}

