/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.util.Locale;
import java.util.Set;
import java.util.spi.LocaleNameProvider;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.LocaleProviderAdapter;

public class LocaleNameProviderImpl
extends LocaleNameProvider
implements AvailableLanguageTags {
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    public LocaleNameProviderImpl(LocaleProviderAdapter.Type type, Set<String> set) {
        this.type = type;
        this.langtags = set;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.toLocaleArray(this.langtags);
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        return LocaleProviderAdapter.isSupportedLocale(locale, this.type, this.langtags);
    }

    @Override
    public String getDisplayLanguage(String string, Locale locale) {
        return this.getDisplayString(string, locale);
    }

    @Override
    public String getDisplayScript(String string, Locale locale) {
        return this.getDisplayString(string, locale);
    }

    @Override
    public String getDisplayCountry(String string, Locale locale) {
        return this.getDisplayString(string, locale);
    }

    @Override
    public String getDisplayVariant(String string, Locale locale) {
        return this.getDisplayString("%%" + string, locale);
    }

    private String getDisplayString(String string, Locale locale) {
        if (string == null || locale == null) {
            throw new NullPointerException();
        }
        return LocaleProviderAdapter.forType(this.type).getLocaleResources(locale).getLocaleName(string);
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }
}

