/*
 * Copyright (C) 2017  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _gc_9_1_SH_MASK_HEADER
#define _gc_9_1_SH_MASK_HEADER


// addressBlock: gc_grbmdec
//GRBM_CNTL
#define GRBM_CNTL__READ_TIMEOUT__SHIFT                                                                        0x0
#define GRBM_CNTL__REPORT_LAST_RDERR__SHIFT                                                                   0x1f
#define GRBM_CNTL__READ_TIMEOUT_MASK                                                                          0x000000FFL
#define GRBM_CNTL__REPORT_LAST_RDERR_MASK                                                                     0x80000000L
//GRBM_SKEW_CNTL
#define GRBM_SKEW_CNTL__SKEW_TOP_THRESHOLD__SHIFT                                                             0x0
#define GRBM_SKEW_CNTL__SKEW_COUNT__SHIFT                                                                     0x6
#define GRBM_SKEW_CNTL__SKEW_TOP_THRESHOLD_MASK                                                               0x0000003FL
#define GRBM_SKEW_CNTL__SKEW_COUNT_MASK                                                                       0x00000FC0L
//GRBM_STATUS2
#define GRBM_STATUS2__ME0PIPE1_CMDFIFO_AVAIL__SHIFT                                                           0x0
#define GRBM_STATUS2__ME0PIPE1_CF_RQ_PENDING__SHIFT                                                           0x4
#define GRBM_STATUS2__ME0PIPE1_PF_RQ_PENDING__SHIFT                                                           0x5
#define GRBM_STATUS2__ME1PIPE0_RQ_PENDING__SHIFT                                                              0x6
#define GRBM_STATUS2__ME1PIPE1_RQ_PENDING__SHIFT                                                              0x7
#define GRBM_STATUS2__ME1PIPE2_RQ_PENDING__SHIFT                                                              0x8
#define GRBM_STATUS2__ME1PIPE3_RQ_PENDING__SHIFT                                                              0x9
#define GRBM_STATUS2__ME2PIPE0_RQ_PENDING__SHIFT                                                              0xa
#define GRBM_STATUS2__ME2PIPE1_RQ_PENDING__SHIFT                                                              0xb
#define GRBM_STATUS2__ME2PIPE2_RQ_PENDING__SHIFT                                                              0xc
#define GRBM_STATUS2__ME2PIPE3_RQ_PENDING__SHIFT                                                              0xd
#define GRBM_STATUS2__RLC_RQ_PENDING__SHIFT                                                                   0xe
#define GRBM_STATUS2__UTCL2_BUSY__SHIFT                                                                       0xf
#define GRBM_STATUS2__EA_BUSY__SHIFT                                                                          0x10
#define GRBM_STATUS2__RMI_BUSY__SHIFT                                                                         0x11
#define GRBM_STATUS2__UTCL2_RQ_PENDING__SHIFT                                                                 0x12
#define GRBM_STATUS2__CPF_RQ_PENDING__SHIFT                                                                   0x13
#define GRBM_STATUS2__EA_LINK_BUSY__SHIFT                                                                     0x14
#define GRBM_STATUS2__RLC_BUSY__SHIFT                                                                         0x18
#define GRBM_STATUS2__TC_BUSY__SHIFT                                                                          0x19
#define GRBM_STATUS2__TCC_CC_RESIDENT__SHIFT                                                                  0x1a
#define GRBM_STATUS2__CPF_BUSY__SHIFT                                                                         0x1c
#define GRBM_STATUS2__CPC_BUSY__SHIFT                                                                         0x1d
#define GRBM_STATUS2__CPG_BUSY__SHIFT                                                                         0x1e
#define GRBM_STATUS2__CPAXI_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS2__ME0PIPE1_CMDFIFO_AVAIL_MASK                                                             0x0000000FL
#define GRBM_STATUS2__ME0PIPE1_CF_RQ_PENDING_MASK                                                             0x00000010L
#define GRBM_STATUS2__ME0PIPE1_PF_RQ_PENDING_MASK                                                             0x00000020L
#define GRBM_STATUS2__ME1PIPE0_RQ_PENDING_MASK                                                                0x00000040L
#define GRBM_STATUS2__ME1PIPE1_RQ_PENDING_MASK                                                                0x00000080L
#define GRBM_STATUS2__ME1PIPE2_RQ_PENDING_MASK                                                                0x00000100L
#define GRBM_STATUS2__ME1PIPE3_RQ_PENDING_MASK                                                                0x00000200L
#define GRBM_STATUS2__ME2PIPE0_RQ_PENDING_MASK                                                                0x00000400L
#define GRBM_STATUS2__ME2PIPE1_RQ_PENDING_MASK                                                                0x00000800L
#define GRBM_STATUS2__ME2PIPE2_RQ_PENDING_MASK                                                                0x00001000L
#define GRBM_STATUS2__ME2PIPE3_RQ_PENDING_MASK                                                                0x00002000L
#define GRBM_STATUS2__RLC_RQ_PENDING_MASK                                                                     0x00004000L
#define GRBM_STATUS2__UTCL2_BUSY_MASK                                                                         0x00008000L
#define GRBM_STATUS2__EA_BUSY_MASK                                                                            0x00010000L
#define GRBM_STATUS2__RMI_BUSY_MASK                                                                           0x00020000L
#define GRBM_STATUS2__UTCL2_RQ_PENDING_MASK                                                                   0x00040000L
#define GRBM_STATUS2__CPF_RQ_PENDING_MASK                                                                     0x00080000L
#define GRBM_STATUS2__EA_LINK_BUSY_MASK                                                                       0x00100000L
#define GRBM_STATUS2__RLC_BUSY_MASK                                                                           0x01000000L
#define GRBM_STATUS2__TC_BUSY_MASK                                                                            0x02000000L
#define GRBM_STATUS2__TCC_CC_RESIDENT_MASK                                                                    0x04000000L
#define GRBM_STATUS2__CPF_BUSY_MASK                                                                           0x10000000L
#define GRBM_STATUS2__CPC_BUSY_MASK                                                                           0x20000000L
#define GRBM_STATUS2__CPG_BUSY_MASK                                                                           0x40000000L
#define GRBM_STATUS2__CPAXI_BUSY_MASK                                                                         0x80000000L
//GRBM_PWR_CNTL
#define GRBM_PWR_CNTL__ALL_REQ_TYPE__SHIFT                                                                    0x0
#define GRBM_PWR_CNTL__GFX_REQ_TYPE__SHIFT                                                                    0x2
#define GRBM_PWR_CNTL__ALL_RSP_TYPE__SHIFT                                                                    0x4
#define GRBM_PWR_CNTL__GFX_RSP_TYPE__SHIFT                                                                    0x6
#define GRBM_PWR_CNTL__GFX_REQ_EN__SHIFT                                                                      0xe
#define GRBM_PWR_CNTL__ALL_REQ_EN__SHIFT                                                                      0xf
#define GRBM_PWR_CNTL__ALL_REQ_TYPE_MASK                                                                      0x00000003L
#define GRBM_PWR_CNTL__GFX_REQ_TYPE_MASK                                                                      0x0000000CL
#define GRBM_PWR_CNTL__ALL_RSP_TYPE_MASK                                                                      0x00000030L
#define GRBM_PWR_CNTL__GFX_RSP_TYPE_MASK                                                                      0x000000C0L
#define GRBM_PWR_CNTL__GFX_REQ_EN_MASK                                                                        0x00004000L
#define GRBM_PWR_CNTL__ALL_REQ_EN_MASK                                                                        0x00008000L
//GRBM_STATUS
#define GRBM_STATUS__ME0PIPE0_CMDFIFO_AVAIL__SHIFT                                                            0x0
#define GRBM_STATUS__RSMU_RQ_PENDING__SHIFT                                                                   0x5
#define GRBM_STATUS__ME0PIPE0_CF_RQ_PENDING__SHIFT                                                            0x7
#define GRBM_STATUS__ME0PIPE0_PF_RQ_PENDING__SHIFT                                                            0x8
#define GRBM_STATUS__GDS_DMA_RQ_PENDING__SHIFT                                                                0x9
#define GRBM_STATUS__DB_CLEAN__SHIFT                                                                          0xc
#define GRBM_STATUS__CB_CLEAN__SHIFT                                                                          0xd
#define GRBM_STATUS__TA_BUSY__SHIFT                                                                           0xe
#define GRBM_STATUS__GDS_BUSY__SHIFT                                                                          0xf
#define GRBM_STATUS__WD_BUSY_NO_DMA__SHIFT                                                                    0x10
#define GRBM_STATUS__VGT_BUSY__SHIFT                                                                          0x11
#define GRBM_STATUS__IA_BUSY_NO_DMA__SHIFT                                                                    0x12
#define GRBM_STATUS__IA_BUSY__SHIFT                                                                           0x13
#define GRBM_STATUS__SX_BUSY__SHIFT                                                                           0x14
#define GRBM_STATUS__WD_BUSY__SHIFT                                                                           0x15
#define GRBM_STATUS__SPI_BUSY__SHIFT                                                                          0x16
#define GRBM_STATUS__BCI_BUSY__SHIFT                                                                          0x17
#define GRBM_STATUS__SC_BUSY__SHIFT                                                                           0x18
#define GRBM_STATUS__PA_BUSY__SHIFT                                                                           0x19
#define GRBM_STATUS__DB_BUSY__SHIFT                                                                           0x1a
#define GRBM_STATUS__CP_COHERENCY_BUSY__SHIFT                                                                 0x1c
#define GRBM_STATUS__CP_BUSY__SHIFT                                                                           0x1d
#define GRBM_STATUS__CB_BUSY__SHIFT                                                                           0x1e
#define GRBM_STATUS__GUI_ACTIVE__SHIFT                                                                        0x1f
#define GRBM_STATUS__ME0PIPE0_CMDFIFO_AVAIL_MASK                                                              0x0000000FL
#define GRBM_STATUS__RSMU_RQ_PENDING_MASK                                                                     0x00000020L
#define GRBM_STATUS__ME0PIPE0_CF_RQ_PENDING_MASK                                                              0x00000080L
#define GRBM_STATUS__ME0PIPE0_PF_RQ_PENDING_MASK                                                              0x00000100L
#define GRBM_STATUS__GDS_DMA_RQ_PENDING_MASK                                                                  0x00000200L
#define GRBM_STATUS__DB_CLEAN_MASK                                                                            0x00001000L
#define GRBM_STATUS__CB_CLEAN_MASK                                                                            0x00002000L
#define GRBM_STATUS__TA_BUSY_MASK                                                                             0x00004000L
#define GRBM_STATUS__GDS_BUSY_MASK                                                                            0x00008000L
#define GRBM_STATUS__WD_BUSY_NO_DMA_MASK                                                                      0x00010000L
#define GRBM_STATUS__VGT_BUSY_MASK                                                                            0x00020000L
#define GRBM_STATUS__IA_BUSY_NO_DMA_MASK                                                                      0x00040000L
#define GRBM_STATUS__IA_BUSY_MASK                                                                             0x00080000L
#define GRBM_STATUS__SX_BUSY_MASK                                                                             0x00100000L
#define GRBM_STATUS__WD_BUSY_MASK                                                                             0x00200000L
#define GRBM_STATUS__SPI_BUSY_MASK                                                                            0x00400000L
#define GRBM_STATUS__BCI_BUSY_MASK                                                                            0x00800000L
#define GRBM_STATUS__SC_BUSY_MASK                                                                             0x01000000L
#define GRBM_STATUS__PA_BUSY_MASK                                                                             0x02000000L
#define GRBM_STATUS__DB_BUSY_MASK                                                                             0x04000000L
#define GRBM_STATUS__CP_COHERENCY_BUSY_MASK                                                                   0x10000000L
#define GRBM_STATUS__CP_BUSY_MASK                                                                             0x20000000L
#define GRBM_STATUS__CB_BUSY_MASK                                                                             0x40000000L
#define GRBM_STATUS__GUI_ACTIVE_MASK                                                                          0x80000000L
//GRBM_STATUS_SE0
#define GRBM_STATUS_SE0__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE0__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE0__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE0__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE0__VGT_BUSY__SHIFT                                                                      0x17
#define GRBM_STATUS_SE0__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE0__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE0__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE0__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE0__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE0__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE0__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE0__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE0__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE0__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE0__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE0__VGT_BUSY_MASK                                                                        0x00800000L
#define GRBM_STATUS_SE0__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE0__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE0__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE0__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE0__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE0__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE0__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_STATUS_SE1
#define GRBM_STATUS_SE1__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE1__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE1__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE1__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE1__VGT_BUSY__SHIFT                                                                      0x17
#define GRBM_STATUS_SE1__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE1__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE1__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE1__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE1__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE1__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE1__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE1__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE1__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE1__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE1__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE1__VGT_BUSY_MASK                                                                        0x00800000L
#define GRBM_STATUS_SE1__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE1__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE1__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE1__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE1__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE1__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE1__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_SOFT_RESET
#define GRBM_SOFT_RESET__SOFT_RESET_CP__SHIFT                                                                 0x0
#define GRBM_SOFT_RESET__SOFT_RESET_RLC__SHIFT                                                                0x2
#define GRBM_SOFT_RESET__SOFT_RESET_GFX__SHIFT                                                                0x10
#define GRBM_SOFT_RESET__SOFT_RESET_CPF__SHIFT                                                                0x11
#define GRBM_SOFT_RESET__SOFT_RESET_CPC__SHIFT                                                                0x12
#define GRBM_SOFT_RESET__SOFT_RESET_CPG__SHIFT                                                                0x13
#define GRBM_SOFT_RESET__SOFT_RESET_CAC__SHIFT                                                                0x14
#define GRBM_SOFT_RESET__SOFT_RESET_CPAXI__SHIFT                                                              0x15
#define GRBM_SOFT_RESET__SOFT_RESET_EA__SHIFT                                                                 0x16
#define GRBM_SOFT_RESET__SOFT_RESET_CP_MASK                                                                   0x00000001L
#define GRBM_SOFT_RESET__SOFT_RESET_RLC_MASK                                                                  0x00000004L
#define GRBM_SOFT_RESET__SOFT_RESET_GFX_MASK                                                                  0x00010000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPF_MASK                                                                  0x00020000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPC_MASK                                                                  0x00040000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPG_MASK                                                                  0x00080000L
#define GRBM_SOFT_RESET__SOFT_RESET_CAC_MASK                                                                  0x00100000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPAXI_MASK                                                                0x00200000L
#define GRBM_SOFT_RESET__SOFT_RESET_EA_MASK                                                                   0x00400000L
//GRBM_CGTT_CLK_CNTL
#define GRBM_CGTT_CLK_CNTL__ON_DELAY__SHIFT                                                                   0x0
#define GRBM_CGTT_CLK_CNTL__OFF_HYSTERESIS__SHIFT                                                             0x4
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE7__SHIFT                                                       0x10
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE6__SHIFT                                                       0x11
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE5__SHIFT                                                       0x12
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE4__SHIFT                                                       0x13
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE3__SHIFT                                                       0x14
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE2__SHIFT                                                       0x15
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE1__SHIFT                                                       0x16
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE0__SHIFT                                                       0x17
#define GRBM_CGTT_CLK_CNTL__SOFT_OVERRIDE_DYN__SHIFT                                                          0x1e
#define GRBM_CGTT_CLK_CNTL__ON_DELAY_MASK                                                                     0x0000000FL
#define GRBM_CGTT_CLK_CNTL__OFF_HYSTERESIS_MASK                                                               0x00000FF0L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE7_MASK                                                         0x00010000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE6_MASK                                                         0x00020000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE5_MASK                                                         0x00040000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE4_MASK                                                         0x00080000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE3_MASK                                                         0x00100000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE2_MASK                                                         0x00200000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE1_MASK                                                         0x00400000L
#define GRBM_CGTT_CLK_CNTL__SOFT_STALL_OVERRIDE0_MASK                                                         0x00800000L
#define GRBM_CGTT_CLK_CNTL__SOFT_OVERRIDE_DYN_MASK                                                            0x40000000L
//GRBM_GFX_CLKEN_CNTL
#define GRBM_GFX_CLKEN_CNTL__PREFIX_DELAY_CNT__SHIFT                                                          0x0
#define GRBM_GFX_CLKEN_CNTL__POST_DELAY_CNT__SHIFT                                                            0x8
#define GRBM_GFX_CLKEN_CNTL__PREFIX_DELAY_CNT_MASK                                                            0x0000000FL
#define GRBM_GFX_CLKEN_CNTL__POST_DELAY_CNT_MASK                                                              0x00001F00L
//GRBM_WAIT_IDLE_CLOCKS
#define GRBM_WAIT_IDLE_CLOCKS__WAIT_IDLE_CLOCKS__SHIFT                                                        0x0
#define GRBM_WAIT_IDLE_CLOCKS__WAIT_IDLE_CLOCKS_MASK                                                          0x000000FFL
//GRBM_STATUS_SE2
#define GRBM_STATUS_SE2__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE2__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE2__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE2__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE2__VGT_BUSY__SHIFT                                                                      0x17
#define GRBM_STATUS_SE2__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE2__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE2__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE2__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE2__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE2__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE2__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE2__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE2__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE2__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE2__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE2__VGT_BUSY_MASK                                                                        0x00800000L
#define GRBM_STATUS_SE2__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE2__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE2__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE2__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE2__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE2__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE2__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_STATUS_SE3
#define GRBM_STATUS_SE3__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE3__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE3__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE3__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE3__VGT_BUSY__SHIFT                                                                      0x17
#define GRBM_STATUS_SE3__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE3__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE3__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE3__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE3__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE3__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE3__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE3__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE3__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE3__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE3__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE3__VGT_BUSY_MASK                                                                        0x00800000L
#define GRBM_STATUS_SE3__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE3__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE3__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE3__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE3__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE3__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE3__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_READ_ERROR
#define GRBM_READ_ERROR__READ_ADDRESS__SHIFT                                                                  0x2
#define GRBM_READ_ERROR__READ_PIPEID__SHIFT                                                                   0x14
#define GRBM_READ_ERROR__READ_MEID__SHIFT                                                                     0x16
#define GRBM_READ_ERROR__READ_ERROR__SHIFT                                                                    0x1f
#define GRBM_READ_ERROR__READ_ADDRESS_MASK                                                                    0x0003FFFCL
#define GRBM_READ_ERROR__READ_PIPEID_MASK                                                                     0x00300000L
#define GRBM_READ_ERROR__READ_MEID_MASK                                                                       0x00C00000L
#define GRBM_READ_ERROR__READ_ERROR_MASK                                                                      0x80000000L
//GRBM_READ_ERROR2
#define GRBM_READ_ERROR2__READ_REQUESTER_CPF__SHIFT                                                           0x10
#define GRBM_READ_ERROR2__READ_REQUESTER_RSMU__SHIFT                                                          0x11
#define GRBM_READ_ERROR2__READ_REQUESTER_RLC__SHIFT                                                           0x12
#define GRBM_READ_ERROR2__READ_REQUESTER_GDS_DMA__SHIFT                                                       0x13
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_CF__SHIFT                                                   0x14
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_PF__SHIFT                                                   0x15
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_CF__SHIFT                                                   0x16
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_PF__SHIFT                                                   0x17
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE0__SHIFT                                                      0x18
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE1__SHIFT                                                      0x19
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE2__SHIFT                                                      0x1a
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE3__SHIFT                                                      0x1b
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE0__SHIFT                                                      0x1c
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE1__SHIFT                                                      0x1d
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE2__SHIFT                                                      0x1e
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE3__SHIFT                                                      0x1f
#define GRBM_READ_ERROR2__READ_REQUESTER_CPF_MASK                                                             0x00010000L
#define GRBM_READ_ERROR2__READ_REQUESTER_RSMU_MASK                                                            0x00020000L
#define GRBM_READ_ERROR2__READ_REQUESTER_RLC_MASK                                                             0x00040000L
#define GRBM_READ_ERROR2__READ_REQUESTER_GDS_DMA_MASK                                                         0x00080000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_CF_MASK                                                     0x00100000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_PF_MASK                                                     0x00200000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_CF_MASK                                                     0x00400000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_PF_MASK                                                     0x00800000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE0_MASK                                                        0x01000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE1_MASK                                                        0x02000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE2_MASK                                                        0x04000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE3_MASK                                                        0x08000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE0_MASK                                                        0x10000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE1_MASK                                                        0x20000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE2_MASK                                                        0x40000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE3_MASK                                                        0x80000000L
//GRBM_INT_CNTL
#define GRBM_INT_CNTL__RDERR_INT_ENABLE__SHIFT                                                                0x0
#define GRBM_INT_CNTL__GUI_IDLE_INT_ENABLE__SHIFT                                                             0x13
#define GRBM_INT_CNTL__RDERR_INT_ENABLE_MASK                                                                  0x00000001L
#define GRBM_INT_CNTL__GUI_IDLE_INT_ENABLE_MASK                                                               0x00080000L
//GRBM_TRAP_OP
#define GRBM_TRAP_OP__RW__SHIFT                                                                               0x0
#define GRBM_TRAP_OP__RW_MASK                                                                                 0x00000001L
//GRBM_TRAP_ADDR
#define GRBM_TRAP_ADDR__DATA__SHIFT                                                                           0x0
#define GRBM_TRAP_ADDR__DATA_MASK                                                                             0x0003FFFFL
//GRBM_TRAP_ADDR_MSK
#define GRBM_TRAP_ADDR_MSK__DATA__SHIFT                                                                       0x0
#define GRBM_TRAP_ADDR_MSK__DATA_MASK                                                                         0x0003FFFFL
//GRBM_TRAP_WD
#define GRBM_TRAP_WD__DATA__SHIFT                                                                             0x0
#define GRBM_TRAP_WD__DATA_MASK                                                                               0xFFFFFFFFL
//GRBM_TRAP_WD_MSK
#define GRBM_TRAP_WD_MSK__DATA__SHIFT                                                                         0x0
#define GRBM_TRAP_WD_MSK__DATA_MASK                                                                           0xFFFFFFFFL
//GRBM_DSM_BYPASS
#define GRBM_DSM_BYPASS__BYPASS_BITS__SHIFT                                                                   0x0
#define GRBM_DSM_BYPASS__BYPASS_EN__SHIFT                                                                     0x2
#define GRBM_DSM_BYPASS__BYPASS_BITS_MASK                                                                     0x00000003L
#define GRBM_DSM_BYPASS__BYPASS_EN_MASK                                                                       0x00000004L
//GRBM_WRITE_ERROR
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RLC__SHIFT                                                          0x0
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RSMU__SHIFT                                                         0x1
#define GRBM_WRITE_ERROR__WRITE_SSRCID__SHIFT                                                                 0x2
#define GRBM_WRITE_ERROR__WRITE_VFID__SHIFT                                                                   0x5
#define GRBM_WRITE_ERROR__WRITE_VF__SHIFT                                                                     0xc
#define GRBM_WRITE_ERROR__WRITE_VMID__SHIFT                                                                   0xd
#define GRBM_WRITE_ERROR__WRITE_PIPEID__SHIFT                                                                 0x14
#define GRBM_WRITE_ERROR__WRITE_MEID__SHIFT                                                                   0x16
#define GRBM_WRITE_ERROR__WRITE_ERROR__SHIFT                                                                  0x1f
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RLC_MASK                                                            0x00000001L
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RSMU_MASK                                                           0x00000002L
#define GRBM_WRITE_ERROR__WRITE_SSRCID_MASK                                                                   0x0000001CL
#define GRBM_WRITE_ERROR__WRITE_VFID_MASK                                                                     0x000001E0L
#define GRBM_WRITE_ERROR__WRITE_VF_MASK                                                                       0x00001000L
#define GRBM_WRITE_ERROR__WRITE_VMID_MASK                                                                     0x0001E000L
#define GRBM_WRITE_ERROR__WRITE_PIPEID_MASK                                                                   0x00300000L
#define GRBM_WRITE_ERROR__WRITE_MEID_MASK                                                                     0x00C00000L
#define GRBM_WRITE_ERROR__WRITE_ERROR_MASK                                                                    0x80000000L
//GRBM_IOV_ERROR
#define GRBM_IOV_ERROR__IOV_ADDR__SHIFT                                                                       0x2
#define GRBM_IOV_ERROR__IOV_VFID__SHIFT                                                                       0x14
#define GRBM_IOV_ERROR__IOV_VF__SHIFT                                                                         0x1a
#define GRBM_IOV_ERROR__IOV_OP__SHIFT                                                                         0x1b
#define GRBM_IOV_ERROR__IOV_ERROR__SHIFT                                                                      0x1f
#define GRBM_IOV_ERROR__IOV_ADDR_MASK                                                                         0x000FFFFCL
#define GRBM_IOV_ERROR__IOV_VFID_MASK                                                                         0x03F00000L
#define GRBM_IOV_ERROR__IOV_VF_MASK                                                                           0x04000000L
#define GRBM_IOV_ERROR__IOV_OP_MASK                                                                           0x08000000L
#define GRBM_IOV_ERROR__IOV_ERROR_MASK                                                                        0x80000000L
//GRBM_CHIP_REVISION
#define GRBM_CHIP_REVISION__CHIP_REVISION__SHIFT                                                              0x0
#define GRBM_CHIP_REVISION__CHIP_REVISION_MASK                                                                0x000000FFL
//GRBM_GFX_CNTL
#define GRBM_GFX_CNTL__PIPEID__SHIFT                                                                          0x0
#define GRBM_GFX_CNTL__MEID__SHIFT                                                                            0x2
#define GRBM_GFX_CNTL__VMID__SHIFT                                                                            0x4
#define GRBM_GFX_CNTL__QUEUEID__SHIFT                                                                         0x8
#define GRBM_GFX_CNTL__PIPEID_MASK                                                                            0x00000003L
#define GRBM_GFX_CNTL__MEID_MASK                                                                              0x0000000CL
#define GRBM_GFX_CNTL__VMID_MASK                                                                              0x000000F0L
#define GRBM_GFX_CNTL__QUEUEID_MASK                                                                           0x00000700L
//GRBM_RSMU_CFG
#define GRBM_RSMU_CFG__APERTURE_ID__SHIFT                                                                     0x0
#define GRBM_RSMU_CFG__QOS__SHIFT                                                                             0xc
#define GRBM_RSMU_CFG__POSTED_WR__SHIFT                                                                       0x10
#define GRBM_RSMU_CFG__APERTURE_ID_MASK                                                                       0x00000FFFL
#define GRBM_RSMU_CFG__QOS_MASK                                                                               0x0000F000L
#define GRBM_RSMU_CFG__POSTED_WR_MASK                                                                         0x00010000L
//GRBM_IH_CREDIT
#define GRBM_IH_CREDIT__CREDIT_VALUE__SHIFT                                                                   0x0
#define GRBM_IH_CREDIT__IH_CLIENT_ID__SHIFT                                                                   0x10
#define GRBM_IH_CREDIT__CREDIT_VALUE_MASK                                                                     0x00000003L
#define GRBM_IH_CREDIT__IH_CLIENT_ID_MASK                                                                     0x00FF0000L
//GRBM_PWR_CNTL2
#define GRBM_PWR_CNTL2__PWR_REQUEST_HALT__SHIFT                                                               0x10
#define GRBM_PWR_CNTL2__PWR_GFX3D_REQUEST_HALT__SHIFT                                                         0x14
#define GRBM_PWR_CNTL2__PWR_REQUEST_HALT_MASK                                                                 0x00010000L
#define GRBM_PWR_CNTL2__PWR_GFX3D_REQUEST_HALT_MASK                                                           0x00100000L
//GRBM_UTCL2_INVAL_RANGE_START
#define GRBM_UTCL2_INVAL_RANGE_START__DATA__SHIFT                                                             0x0
#define GRBM_UTCL2_INVAL_RANGE_START__DATA_MASK                                                               0x0003FFFFL
//GRBM_UTCL2_INVAL_RANGE_END
#define GRBM_UTCL2_INVAL_RANGE_END__DATA__SHIFT                                                               0x0
#define GRBM_UTCL2_INVAL_RANGE_END__DATA_MASK                                                                 0x0003FFFFL
//GRBM_RSMU_READ_ERROR
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ADDRESS__SHIFT                                                        0x2
#define GRBM_RSMU_READ_ERROR__RSMU_READ_VF__SHIFT                                                             0x14
#define GRBM_RSMU_READ_ERROR__RSMU_READ_VFID__SHIFT                                                           0x15
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ERROR_TYPE__SHIFT                                                     0x1b
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ERROR__SHIFT                                                          0x1f
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ADDRESS_MASK                                                          0x000FFFFCL
#define GRBM_RSMU_READ_ERROR__RSMU_READ_VF_MASK                                                               0x00100000L
#define GRBM_RSMU_READ_ERROR__RSMU_READ_VFID_MASK                                                             0x07E00000L
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ERROR_TYPE_MASK                                                       0x08000000L
#define GRBM_RSMU_READ_ERROR__RSMU_READ_ERROR_MASK                                                            0x80000000L
//GRBM_CHICKEN_BITS
#define GRBM_CHICKEN_BITS__DISABLE_CP_VMID_RESET_REQ__SHIFT                                                   0x0
#define GRBM_CHICKEN_BITS__DISABLE_CP_VMID_RESET_REQ_MASK                                                     0x00000001L
//GRBM_NOWHERE
#define GRBM_NOWHERE__DATA__SHIFT                                                                             0x0
#define GRBM_NOWHERE__DATA_MASK                                                                               0xFFFFFFFFL
//GRBM_SCRATCH_REG0
#define GRBM_SCRATCH_REG0__SCRATCH_REG0__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG0__SCRATCH_REG0_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG1
#define GRBM_SCRATCH_REG1__SCRATCH_REG1__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG1__SCRATCH_REG1_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG2
#define GRBM_SCRATCH_REG2__SCRATCH_REG2__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG2__SCRATCH_REG2_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG3
#define GRBM_SCRATCH_REG3__SCRATCH_REG3__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG3__SCRATCH_REG3_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG4
#define GRBM_SCRATCH_REG4__SCRATCH_REG4__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG4__SCRATCH_REG4_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG5
#define GRBM_SCRATCH_REG5__SCRATCH_REG5__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG5__SCRATCH_REG5_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG6
#define GRBM_SCRATCH_REG6__SCRATCH_REG6__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG6__SCRATCH_REG6_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG7
#define GRBM_SCRATCH_REG7__SCRATCH_REG7__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG7__SCRATCH_REG7_MASK                                                                  0xFFFFFFFFL


// addressBlock: gc_cpdec
//CP_CPC_STATUS
#define CP_CPC_STATUS__MEC1_BUSY__SHIFT                                                                       0x0
#define CP_CPC_STATUS__MEC2_BUSY__SHIFT                                                                       0x1
#define CP_CPC_STATUS__DC0_BUSY__SHIFT                                                                        0x2
#define CP_CPC_STATUS__DC1_BUSY__SHIFT                                                                        0x3
#define CP_CPC_STATUS__RCIU1_BUSY__SHIFT                                                                      0x4
#define CP_CPC_STATUS__RCIU2_BUSY__SHIFT                                                                      0x5
#define CP_CPC_STATUS__ROQ1_BUSY__SHIFT                                                                       0x6
#define CP_CPC_STATUS__ROQ2_BUSY__SHIFT                                                                       0x7
#define CP_CPC_STATUS__TCIU_BUSY__SHIFT                                                                       0xa
#define CP_CPC_STATUS__SCRATCH_RAM_BUSY__SHIFT                                                                0xb
#define CP_CPC_STATUS__QU_BUSY__SHIFT                                                                         0xc
#define CP_CPC_STATUS__UTCL2IU_BUSY__SHIFT                                                                    0xd
#define CP_CPC_STATUS__SAVE_RESTORE_BUSY__SHIFT                                                               0xe
#define CP_CPC_STATUS__CPG_CPC_BUSY__SHIFT                                                                    0x1d
#define CP_CPC_STATUS__CPF_CPC_BUSY__SHIFT                                                                    0x1e
#define CP_CPC_STATUS__CPC_BUSY__SHIFT                                                                        0x1f
#define CP_CPC_STATUS__MEC1_BUSY_MASK                                                                         0x00000001L
#define CP_CPC_STATUS__MEC2_BUSY_MASK                                                                         0x00000002L
#define CP_CPC_STATUS__DC0_BUSY_MASK                                                                          0x00000004L
#define CP_CPC_STATUS__DC1_BUSY_MASK                                                                          0x00000008L
#define CP_CPC_STATUS__RCIU1_BUSY_MASK                                                                        0x00000010L
#define CP_CPC_STATUS__RCIU2_BUSY_MASK                                                                        0x00000020L
#define CP_CPC_STATUS__ROQ1_BUSY_MASK                                                                         0x00000040L
#define CP_CPC_STATUS__ROQ2_BUSY_MASK                                                                         0x00000080L
#define CP_CPC_STATUS__TCIU_BUSY_MASK                                                                         0x00000400L
#define CP_CPC_STATUS__SCRATCH_RAM_BUSY_MASK                                                                  0x00000800L
#define CP_CPC_STATUS__QU_BUSY_MASK                                                                           0x00001000L
#define CP_CPC_STATUS__UTCL2IU_BUSY_MASK                                                                      0x00002000L
#define CP_CPC_STATUS__SAVE_RESTORE_BUSY_MASK                                                                 0x00004000L
#define CP_CPC_STATUS__CPG_CPC_BUSY_MASK                                                                      0x20000000L
#define CP_CPC_STATUS__CPF_CPC_BUSY_MASK                                                                      0x40000000L
#define CP_CPC_STATUS__CPC_BUSY_MASK                                                                          0x80000000L
//CP_CPC_BUSY_STAT
#define CP_CPC_BUSY_STAT__MEC1_LOAD_BUSY__SHIFT                                                               0x0
#define CP_CPC_BUSY_STAT__MEC1_SEMAPOHRE_BUSY__SHIFT                                                          0x1
#define CP_CPC_BUSY_STAT__MEC1_MUTEX_BUSY__SHIFT                                                              0x2
#define CP_CPC_BUSY_STAT__MEC1_MESSAGE_BUSY__SHIFT                                                            0x3
#define CP_CPC_BUSY_STAT__MEC1_EOP_QUEUE_BUSY__SHIFT                                                          0x4
#define CP_CPC_BUSY_STAT__MEC1_IQ_QUEUE_BUSY__SHIFT                                                           0x5
#define CP_CPC_BUSY_STAT__MEC1_IB_QUEUE_BUSY__SHIFT                                                           0x6
#define CP_CPC_BUSY_STAT__MEC1_TC_BUSY__SHIFT                                                                 0x7
#define CP_CPC_BUSY_STAT__MEC1_DMA_BUSY__SHIFT                                                                0x8
#define CP_CPC_BUSY_STAT__MEC1_PARTIAL_FLUSH_BUSY__SHIFT                                                      0x9
#define CP_CPC_BUSY_STAT__MEC1_PIPE0_BUSY__SHIFT                                                              0xa
#define CP_CPC_BUSY_STAT__MEC1_PIPE1_BUSY__SHIFT                                                              0xb
#define CP_CPC_BUSY_STAT__MEC1_PIPE2_BUSY__SHIFT                                                              0xc
#define CP_CPC_BUSY_STAT__MEC1_PIPE3_BUSY__SHIFT                                                              0xd
#define CP_CPC_BUSY_STAT__MEC2_LOAD_BUSY__SHIFT                                                               0x10
#define CP_CPC_BUSY_STAT__MEC2_SEMAPOHRE_BUSY__SHIFT                                                          0x11
#define CP_CPC_BUSY_STAT__MEC2_MUTEX_BUSY__SHIFT                                                              0x12
#define CP_CPC_BUSY_STAT__MEC2_MESSAGE_BUSY__SHIFT                                                            0x13
#define CP_CPC_BUSY_STAT__MEC2_EOP_QUEUE_BUSY__SHIFT                                                          0x14
#define CP_CPC_BUSY_STAT__MEC2_IQ_QUEUE_BUSY__SHIFT                                                           0x15
#define CP_CPC_BUSY_STAT__MEC2_IB_QUEUE_BUSY__SHIFT                                                           0x16
#define CP_CPC_BUSY_STAT__MEC2_TC_BUSY__SHIFT                                                                 0x17
#define CP_CPC_BUSY_STAT__MEC2_DMA_BUSY__SHIFT                                                                0x18
#define CP_CPC_BUSY_STAT__MEC2_PARTIAL_FLUSH_BUSY__SHIFT                                                      0x19
#define CP_CPC_BUSY_STAT__MEC2_PIPE0_BUSY__SHIFT                                                              0x1a
#define CP_CPC_BUSY_STAT__MEC2_PIPE1_BUSY__SHIFT                                                              0x1b
#define CP_CPC_BUSY_STAT__MEC2_PIPE2_BUSY__SHIFT                                                              0x1c
#define CP_CPC_BUSY_STAT__MEC2_PIPE3_BUSY__SHIFT                                                              0x1d
#define CP_CPC_BUSY_STAT__MEC1_LOAD_BUSY_MASK                                                                 0x00000001L
#define CP_CPC_BUSY_STAT__MEC1_SEMAPOHRE_BUSY_MASK                                                            0x00000002L
#define CP_CPC_BUSY_STAT__MEC1_MUTEX_BUSY_MASK                                                                0x00000004L
#define CP_CPC_BUSY_STAT__MEC1_MESSAGE_BUSY_MASK                                                              0x00000008L
#define CP_CPC_BUSY_STAT__MEC1_EOP_QUEUE_BUSY_MASK                                                            0x00000010L
#define CP_CPC_BUSY_STAT__MEC1_IQ_QUEUE_BUSY_MASK                                                             0x00000020L
#define CP_CPC_BUSY_STAT__MEC1_IB_QUEUE_BUSY_MASK                                                             0x00000040L
#define CP_CPC_BUSY_STAT__MEC1_TC_BUSY_MASK                                                                   0x00000080L
#define CP_CPC_BUSY_STAT__MEC1_DMA_BUSY_MASK                                                                  0x00000100L
#define CP_CPC_BUSY_STAT__MEC1_PARTIAL_FLUSH_BUSY_MASK                                                        0x00000200L
#define CP_CPC_BUSY_STAT__MEC1_PIPE0_BUSY_MASK                                                                0x00000400L
#define CP_CPC_BUSY_STAT__MEC1_PIPE1_BUSY_MASK                                                                0x00000800L
#define CP_CPC_BUSY_STAT__MEC1_PIPE2_BUSY_MASK                                                                0x00001000L
#define CP_CPC_BUSY_STAT__MEC1_PIPE3_BUSY_MASK                                                                0x00002000L
#define CP_CPC_BUSY_STAT__MEC2_LOAD_BUSY_MASK                                                                 0x00010000L
#define CP_CPC_BUSY_STAT__MEC2_SEMAPOHRE_BUSY_MASK                                                            0x00020000L
#define CP_CPC_BUSY_STAT__MEC2_MUTEX_BUSY_MASK                                                                0x00040000L
#define CP_CPC_BUSY_STAT__MEC2_MESSAGE_BUSY_MASK                                                              0x00080000L
#define CP_CPC_BUSY_STAT__MEC2_EOP_QUEUE_BUSY_MASK                                                            0x00100000L
#define CP_CPC_BUSY_STAT__MEC2_IQ_QUEUE_BUSY_MASK                                                             0x00200000L
#define CP_CPC_BUSY_STAT__MEC2_IB_QUEUE_BUSY_MASK                                                             0x00400000L
#define CP_CPC_BUSY_STAT__MEC2_TC_BUSY_MASK                                                                   0x00800000L
#define CP_CPC_BUSY_STAT__MEC2_DMA_BUSY_MASK                                                                  0x01000000L
#define CP_CPC_BUSY_STAT__MEC2_PARTIAL_FLUSH_BUSY_MASK                                                        0x02000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE0_BUSY_MASK                                                                0x04000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE1_BUSY_MASK                                                                0x08000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE2_BUSY_MASK                                                                0x10000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE3_BUSY_MASK                                                                0x20000000L
//CP_CPC_STALLED_STAT1
#define CP_CPC_STALLED_STAT1__RCIU_TX_FREE_STALL__SHIFT                                                       0x3
#define CP_CPC_STALLED_STAT1__RCIU_PRIV_VIOLATION__SHIFT                                                      0x4
#define CP_CPC_STALLED_STAT1__TCIU_TX_FREE_STALL__SHIFT                                                       0x6
#define CP_CPC_STALLED_STAT1__MEC1_DECODING_PACKET__SHIFT                                                     0x8
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU__SHIFT                                                        0x9
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_READ__SHIFT                                                   0xa
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_ROQ_DATA__SHIFT                                                    0xd
#define CP_CPC_STALLED_STAT1__MEC2_DECODING_PACKET__SHIFT                                                     0x10
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU__SHIFT                                                        0x11
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_READ__SHIFT                                                   0x12
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_ROQ_DATA__SHIFT                                                    0x15
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE__SHIFT                                                  0x16
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                  0x17
#define CP_CPC_STALLED_STAT1__UTCL1_WAITING_ON_TRANS__SHIFT                                                   0x18
#define CP_CPC_STALLED_STAT1__RCIU_TX_FREE_STALL_MASK                                                         0x00000008L
#define CP_CPC_STALLED_STAT1__RCIU_PRIV_VIOLATION_MASK                                                        0x00000010L
#define CP_CPC_STALLED_STAT1__TCIU_TX_FREE_STALL_MASK                                                         0x00000040L
#define CP_CPC_STALLED_STAT1__MEC1_DECODING_PACKET_MASK                                                       0x00000100L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_MASK                                                          0x00000200L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_READ_MASK                                                     0x00000400L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_ROQ_DATA_MASK                                                      0x00002000L
#define CP_CPC_STALLED_STAT1__MEC2_DECODING_PACKET_MASK                                                       0x00010000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_MASK                                                          0x00020000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_READ_MASK                                                     0x00040000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_ROQ_DATA_MASK                                                      0x00200000L
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE_MASK                                                    0x00400000L
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS_MASK                                                    0x00800000L
#define CP_CPC_STALLED_STAT1__UTCL1_WAITING_ON_TRANS_MASK                                                     0x01000000L
//CP_CPF_STATUS
#define CP_CPF_STATUS__POST_WPTR_GFX_BUSY__SHIFT                                                              0x0
#define CP_CPF_STATUS__CSF_BUSY__SHIFT                                                                        0x1
#define CP_CPF_STATUS__ROQ_ALIGN_BUSY__SHIFT                                                                  0x4
#define CP_CPF_STATUS__ROQ_RING_BUSY__SHIFT                                                                   0x5
#define CP_CPF_STATUS__ROQ_INDIRECT1_BUSY__SHIFT                                                              0x6
#define CP_CPF_STATUS__ROQ_INDIRECT2_BUSY__SHIFT                                                              0x7
#define CP_CPF_STATUS__ROQ_STATE_BUSY__SHIFT                                                                  0x8
#define CP_CPF_STATUS__ROQ_CE_RING_BUSY__SHIFT                                                                0x9
#define CP_CPF_STATUS__ROQ_CE_INDIRECT1_BUSY__SHIFT                                                           0xa
#define CP_CPF_STATUS__ROQ_CE_INDIRECT2_BUSY__SHIFT                                                           0xb
#define CP_CPF_STATUS__SEMAPHORE_BUSY__SHIFT                                                                  0xc
#define CP_CPF_STATUS__INTERRUPT_BUSY__SHIFT                                                                  0xd
#define CP_CPF_STATUS__TCIU_BUSY__SHIFT                                                                       0xe
#define CP_CPF_STATUS__HQD_BUSY__SHIFT                                                                        0xf
#define CP_CPF_STATUS__PRT_BUSY__SHIFT                                                                        0x10
#define CP_CPF_STATUS__UTCL2IU_BUSY__SHIFT                                                                    0x11
#define CP_CPF_STATUS__CPF_GFX_BUSY__SHIFT                                                                    0x1a
#define CP_CPF_STATUS__CPF_CMP_BUSY__SHIFT                                                                    0x1b
#define CP_CPF_STATUS__GRBM_CPF_STAT_BUSY__SHIFT                                                              0x1c
#define CP_CPF_STATUS__CPC_CPF_BUSY__SHIFT                                                                    0x1e
#define CP_CPF_STATUS__CPF_BUSY__SHIFT                                                                        0x1f
#define CP_CPF_STATUS__POST_WPTR_GFX_BUSY_MASK                                                                0x00000001L
#define CP_CPF_STATUS__CSF_BUSY_MASK                                                                          0x00000002L
#define CP_CPF_STATUS__ROQ_ALIGN_BUSY_MASK                                                                    0x00000010L
#define CP_CPF_STATUS__ROQ_RING_BUSY_MASK                                                                     0x00000020L
#define CP_CPF_STATUS__ROQ_INDIRECT1_BUSY_MASK                                                                0x00000040L
#define CP_CPF_STATUS__ROQ_INDIRECT2_BUSY_MASK                                                                0x00000080L
#define CP_CPF_STATUS__ROQ_STATE_BUSY_MASK                                                                    0x00000100L
#define CP_CPF_STATUS__ROQ_CE_RING_BUSY_MASK                                                                  0x00000200L
#define CP_CPF_STATUS__ROQ_CE_INDIRECT1_BUSY_MASK                                                             0x00000400L
#define CP_CPF_STATUS__ROQ_CE_INDIRECT2_BUSY_MASK                                                             0x00000800L
#define CP_CPF_STATUS__SEMAPHORE_BUSY_MASK                                                                    0x00001000L
#define CP_CPF_STATUS__INTERRUPT_BUSY_MASK                                                                    0x00002000L
#define CP_CPF_STATUS__TCIU_BUSY_MASK                                                                         0x00004000L
#define CP_CPF_STATUS__HQD_BUSY_MASK                                                                          0x00008000L
#define CP_CPF_STATUS__PRT_BUSY_MASK                                                                          0x00010000L
#define CP_CPF_STATUS__UTCL2IU_BUSY_MASK                                                                      0x00020000L
#define CP_CPF_STATUS__CPF_GFX_BUSY_MASK                                                                      0x04000000L
#define CP_CPF_STATUS__CPF_CMP_BUSY_MASK                                                                      0x08000000L
#define CP_CPF_STATUS__GRBM_CPF_STAT_BUSY_MASK                                                                0x30000000L
#define CP_CPF_STATUS__CPC_CPF_BUSY_MASK                                                                      0x40000000L
#define CP_CPF_STATUS__CPF_BUSY_MASK                                                                          0x80000000L
//CP_CPF_BUSY_STAT
#define CP_CPF_BUSY_STAT__REG_BUS_FIFO_BUSY__SHIFT                                                            0x0
#define CP_CPF_BUSY_STAT__CSF_RING_BUSY__SHIFT                                                                0x1
#define CP_CPF_BUSY_STAT__CSF_INDIRECT1_BUSY__SHIFT                                                           0x2
#define CP_CPF_BUSY_STAT__CSF_INDIRECT2_BUSY__SHIFT                                                           0x3
#define CP_CPF_BUSY_STAT__CSF_STATE_BUSY__SHIFT                                                               0x4
#define CP_CPF_BUSY_STAT__CSF_CE_INDR1_BUSY__SHIFT                                                            0x5
#define CP_CPF_BUSY_STAT__CSF_CE_INDR2_BUSY__SHIFT                                                            0x6
#define CP_CPF_BUSY_STAT__CSF_ARBITER_BUSY__SHIFT                                                             0x7
#define CP_CPF_BUSY_STAT__CSF_INPUT_BUSY__SHIFT                                                               0x8
#define CP_CPF_BUSY_STAT__OUTSTANDING_READ_TAGS__SHIFT                                                        0x9
#define CP_CPF_BUSY_STAT__HPD_PROCESSING_EOP_BUSY__SHIFT                                                      0xb
#define CP_CPF_BUSY_STAT__HQD_DISPATCH_BUSY__SHIFT                                                            0xc
#define CP_CPF_BUSY_STAT__HQD_IQ_TIMER_BUSY__SHIFT                                                            0xd
#define CP_CPF_BUSY_STAT__HQD_DMA_OFFLOAD_BUSY__SHIFT                                                         0xe
#define CP_CPF_BUSY_STAT__HQD_WAIT_SEMAPHORE_BUSY__SHIFT                                                      0xf
#define CP_CPF_BUSY_STAT__HQD_SIGNAL_SEMAPHORE_BUSY__SHIFT                                                    0x10
#define CP_CPF_BUSY_STAT__HQD_MESSAGE_BUSY__SHIFT                                                             0x11
#define CP_CPF_BUSY_STAT__HQD_PQ_FETCHER_BUSY__SHIFT                                                          0x12
#define CP_CPF_BUSY_STAT__HQD_IB_FETCHER_BUSY__SHIFT                                                          0x13
#define CP_CPF_BUSY_STAT__HQD_IQ_FETCHER_BUSY__SHIFT                                                          0x14
#define CP_CPF_BUSY_STAT__HQD_EOP_FETCHER_BUSY__SHIFT                                                         0x15
#define CP_CPF_BUSY_STAT__HQD_CONSUMED_RPTR_BUSY__SHIFT                                                       0x16
#define CP_CPF_BUSY_STAT__HQD_FETCHER_ARB_BUSY__SHIFT                                                         0x17
#define CP_CPF_BUSY_STAT__HQD_ROQ_ALIGN_BUSY__SHIFT                                                           0x18
#define CP_CPF_BUSY_STAT__HQD_ROQ_EOP_BUSY__SHIFT                                                             0x19
#define CP_CPF_BUSY_STAT__HQD_ROQ_IQ_BUSY__SHIFT                                                              0x1a
#define CP_CPF_BUSY_STAT__HQD_ROQ_PQ_BUSY__SHIFT                                                              0x1b
#define CP_CPF_BUSY_STAT__HQD_ROQ_IB_BUSY__SHIFT                                                              0x1c
#define CP_CPF_BUSY_STAT__HQD_WPTR_POLL_BUSY__SHIFT                                                           0x1d
#define CP_CPF_BUSY_STAT__HQD_PQ_BUSY__SHIFT                                                                  0x1e
#define CP_CPF_BUSY_STAT__HQD_IB_BUSY__SHIFT                                                                  0x1f
#define CP_CPF_BUSY_STAT__REG_BUS_FIFO_BUSY_MASK                                                              0x00000001L
#define CP_CPF_BUSY_STAT__CSF_RING_BUSY_MASK                                                                  0x00000002L
#define CP_CPF_BUSY_STAT__CSF_INDIRECT1_BUSY_MASK                                                             0x00000004L
#define CP_CPF_BUSY_STAT__CSF_INDIRECT2_BUSY_MASK                                                             0x00000008L
#define CP_CPF_BUSY_STAT__CSF_STATE_BUSY_MASK                                                                 0x00000010L
#define CP_CPF_BUSY_STAT__CSF_CE_INDR1_BUSY_MASK                                                              0x00000020L
#define CP_CPF_BUSY_STAT__CSF_CE_INDR2_BUSY_MASK                                                              0x00000040L
#define CP_CPF_BUSY_STAT__CSF_ARBITER_BUSY_MASK                                                               0x00000080L
#define CP_CPF_BUSY_STAT__CSF_INPUT_BUSY_MASK                                                                 0x00000100L
#define CP_CPF_BUSY_STAT__OUTSTANDING_READ_TAGS_MASK                                                          0x00000200L
#define CP_CPF_BUSY_STAT__HPD_PROCESSING_EOP_BUSY_MASK                                                        0x00000800L
#define CP_CPF_BUSY_STAT__HQD_DISPATCH_BUSY_MASK                                                              0x00001000L
#define CP_CPF_BUSY_STAT__HQD_IQ_TIMER_BUSY_MASK                                                              0x00002000L
#define CP_CPF_BUSY_STAT__HQD_DMA_OFFLOAD_BUSY_MASK                                                           0x00004000L
#define CP_CPF_BUSY_STAT__HQD_WAIT_SEMAPHORE_BUSY_MASK                                                        0x00008000L
#define CP_CPF_BUSY_STAT__HQD_SIGNAL_SEMAPHORE_BUSY_MASK                                                      0x00010000L
#define CP_CPF_BUSY_STAT__HQD_MESSAGE_BUSY_MASK                                                               0x00020000L
#define CP_CPF_BUSY_STAT__HQD_PQ_FETCHER_BUSY_MASK                                                            0x00040000L
#define CP_CPF_BUSY_STAT__HQD_IB_FETCHER_BUSY_MASK                                                            0x00080000L
#define CP_CPF_BUSY_STAT__HQD_IQ_FETCHER_BUSY_MASK                                                            0x00100000L
#define CP_CPF_BUSY_STAT__HQD_EOP_FETCHER_BUSY_MASK                                                           0x00200000L
#define CP_CPF_BUSY_STAT__HQD_CONSUMED_RPTR_BUSY_MASK                                                         0x00400000L
#define CP_CPF_BUSY_STAT__HQD_FETCHER_ARB_BUSY_MASK                                                           0x00800000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_ALIGN_BUSY_MASK                                                             0x01000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_EOP_BUSY_MASK                                                               0x02000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_IQ_BUSY_MASK                                                                0x04000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_PQ_BUSY_MASK                                                                0x08000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_IB_BUSY_MASK                                                                0x10000000L
#define CP_CPF_BUSY_STAT__HQD_WPTR_POLL_BUSY_MASK                                                             0x20000000L
#define CP_CPF_BUSY_STAT__HQD_PQ_BUSY_MASK                                                                    0x40000000L
#define CP_CPF_BUSY_STAT__HQD_IB_BUSY_MASK                                                                    0x80000000L
//CP_CPF_STALLED_STAT1
#define CP_CPF_STALLED_STAT1__RING_FETCHING_DATA__SHIFT                                                       0x0
#define CP_CPF_STALLED_STAT1__INDR1_FETCHING_DATA__SHIFT                                                      0x1
#define CP_CPF_STALLED_STAT1__INDR2_FETCHING_DATA__SHIFT                                                      0x2
#define CP_CPF_STALLED_STAT1__STATE_FETCHING_DATA__SHIFT                                                      0x3
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_FREE__SHIFT                                                     0x5
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_TAGS__SHIFT                                                     0x6
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE__SHIFT                                                  0x7
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                  0x8
#define CP_CPF_STALLED_STAT1__GFX_UTCL1_WAITING_ON_TRANS__SHIFT                                               0x9
#define CP_CPF_STALLED_STAT1__CMP_UTCL1_WAITING_ON_TRANS__SHIFT                                               0xa
#define CP_CPF_STALLED_STAT1__RCIU_WAITING_ON_FREE__SHIFT                                                     0xb
#define CP_CPF_STALLED_STAT1__RING_FETCHING_DATA_MASK                                                         0x00000001L
#define CP_CPF_STALLED_STAT1__INDR1_FETCHING_DATA_MASK                                                        0x00000002L
#define CP_CPF_STALLED_STAT1__INDR2_FETCHING_DATA_MASK                                                        0x00000004L
#define CP_CPF_STALLED_STAT1__STATE_FETCHING_DATA_MASK                                                        0x00000008L
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_FREE_MASK                                                       0x00000020L
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_TAGS_MASK                                                       0x00000040L
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE_MASK                                                    0x00000080L
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS_MASK                                                    0x00000100L
#define CP_CPF_STALLED_STAT1__GFX_UTCL1_WAITING_ON_TRANS_MASK                                                 0x00000200L
#define CP_CPF_STALLED_STAT1__CMP_UTCL1_WAITING_ON_TRANS_MASK                                                 0x00000400L
#define CP_CPF_STALLED_STAT1__RCIU_WAITING_ON_FREE_MASK                                                       0x00000800L
//CP_CPC_GRBM_FREE_COUNT
#define CP_CPC_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                             0x0
#define CP_CPC_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                               0x0000003FL
//CP_MEC_CNTL
#define CP_MEC_CNTL__MEC_INVALIDATE_ICACHE__SHIFT                                                             0x4
#define CP_MEC_CNTL__MEC_ME1_PIPE0_RESET__SHIFT                                                               0x10
#define CP_MEC_CNTL__MEC_ME1_PIPE1_RESET__SHIFT                                                               0x11
#define CP_MEC_CNTL__MEC_ME1_PIPE2_RESET__SHIFT                                                               0x12
#define CP_MEC_CNTL__MEC_ME1_PIPE3_RESET__SHIFT                                                               0x13
#define CP_MEC_CNTL__MEC_ME2_PIPE0_RESET__SHIFT                                                               0x14
#define CP_MEC_CNTL__MEC_ME2_PIPE1_RESET__SHIFT                                                               0x15
#define CP_MEC_CNTL__MEC_ME2_HALT__SHIFT                                                                      0x1c
#define CP_MEC_CNTL__MEC_ME2_STEP__SHIFT                                                                      0x1d
#define CP_MEC_CNTL__MEC_ME1_HALT__SHIFT                                                                      0x1e
#define CP_MEC_CNTL__MEC_ME1_STEP__SHIFT                                                                      0x1f
#define CP_MEC_CNTL__MEC_INVALIDATE_ICACHE_MASK                                                               0x00000010L
#define CP_MEC_CNTL__MEC_ME1_PIPE0_RESET_MASK                                                                 0x00010000L
#define CP_MEC_CNTL__MEC_ME1_PIPE1_RESET_MASK                                                                 0x00020000L
#define CP_MEC_CNTL__MEC_ME1_PIPE2_RESET_MASK                                                                 0x00040000L
#define CP_MEC_CNTL__MEC_ME1_PIPE3_RESET_MASK                                                                 0x00080000L
#define CP_MEC_CNTL__MEC_ME2_PIPE0_RESET_MASK                                                                 0x00100000L
#define CP_MEC_CNTL__MEC_ME2_PIPE1_RESET_MASK                                                                 0x00200000L
#define CP_MEC_CNTL__MEC_ME2_HALT_MASK                                                                        0x10000000L
#define CP_MEC_CNTL__MEC_ME2_STEP_MASK                                                                        0x20000000L
#define CP_MEC_CNTL__MEC_ME1_HALT_MASK                                                                        0x40000000L
#define CP_MEC_CNTL__MEC_ME1_STEP_MASK                                                                        0x80000000L
//CP_MEC_ME1_HEADER_DUMP
#define CP_MEC_ME1_HEADER_DUMP__HEADER_DUMP__SHIFT                                                            0x0
#define CP_MEC_ME1_HEADER_DUMP__HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_MEC_ME2_HEADER_DUMP
#define CP_MEC_ME2_HEADER_DUMP__HEADER_DUMP__SHIFT                                                            0x0
#define CP_MEC_ME2_HEADER_DUMP__HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_CPC_SCRATCH_INDEX
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX__SHIFT                                                            0x0
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX_MASK                                                              0x000001FFL
//CP_CPC_SCRATCH_DATA
#define CP_CPC_SCRATCH_DATA__SCRATCH_DATA__SHIFT                                                              0x0
#define CP_CPC_SCRATCH_DATA__SCRATCH_DATA_MASK                                                                0xFFFFFFFFL
//CP_CPF_GRBM_FREE_COUNT
#define CP_CPF_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                             0x0
#define CP_CPF_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                               0x00000007L
//CP_CPC_HALT_HYST_COUNT
#define CP_CPC_HALT_HYST_COUNT__COUNT__SHIFT                                                                  0x0
#define CP_CPC_HALT_HYST_COUNT__COUNT_MASK                                                                    0x0000000FL
//CP_PRT_LOD_STATS_CNTL0
#define CP_PRT_LOD_STATS_CNTL0__BU_SIZE__SHIFT                                                                0x0
#define CP_PRT_LOD_STATS_CNTL0__BU_SIZE_MASK                                                                  0xFFFFFFFFL
//CP_PRT_LOD_STATS_CNTL1
#define CP_PRT_LOD_STATS_CNTL1__BASE_LO__SHIFT                                                                0x0
#define CP_PRT_LOD_STATS_CNTL1__BASE_LO_MASK                                                                  0xFFFFFFFFL
//CP_PRT_LOD_STATS_CNTL2
#define CP_PRT_LOD_STATS_CNTL2__BASE_HI__SHIFT                                                                0x0
#define CP_PRT_LOD_STATS_CNTL2__BASE_HI_MASK                                                                  0x000003FFL
//CP_PRT_LOD_STATS_CNTL3
#define CP_PRT_LOD_STATS_CNTL3__INTERVAL__SHIFT                                                               0x2
#define CP_PRT_LOD_STATS_CNTL3__RESET_CNT__SHIFT                                                              0xa
#define CP_PRT_LOD_STATS_CNTL3__RESET_FORCE__SHIFT                                                            0x12
#define CP_PRT_LOD_STATS_CNTL3__REPORT_AND_RESET__SHIFT                                                       0x13
#define CP_PRT_LOD_STATS_CNTL3__MC_VMID__SHIFT                                                                0x17
#define CP_PRT_LOD_STATS_CNTL3__CACHE_POLICY__SHIFT                                                           0x1c
#define CP_PRT_LOD_STATS_CNTL3__INTERVAL_MASK                                                                 0x000003FCL
#define CP_PRT_LOD_STATS_CNTL3__RESET_CNT_MASK                                                                0x0003FC00L
#define CP_PRT_LOD_STATS_CNTL3__RESET_FORCE_MASK                                                              0x00040000L
#define CP_PRT_LOD_STATS_CNTL3__REPORT_AND_RESET_MASK                                                         0x00080000L
#define CP_PRT_LOD_STATS_CNTL3__MC_VMID_MASK                                                                  0x07800000L
#define CP_PRT_LOD_STATS_CNTL3__CACHE_POLICY_MASK                                                             0x10000000L
//CP_CE_COMPARE_COUNT
#define CP_CE_COMPARE_COUNT__COMPARE_COUNT__SHIFT                                                             0x0
#define CP_CE_COMPARE_COUNT__COMPARE_COUNT_MASK                                                               0xFFFFFFFFL
//CP_CE_DE_COUNT
#define CP_CE_DE_COUNT__DRAW_ENGINE_COUNT__SHIFT                                                              0x0
#define CP_CE_DE_COUNT__DRAW_ENGINE_COUNT_MASK                                                                0xFFFFFFFFL
//CP_DE_CE_COUNT
#define CP_DE_CE_COUNT__CONST_ENGINE_COUNT__SHIFT                                                             0x0
#define CP_DE_CE_COUNT__CONST_ENGINE_COUNT_MASK                                                               0xFFFFFFFFL
//CP_DE_LAST_INVAL_COUNT
#define CP_DE_LAST_INVAL_COUNT__LAST_INVAL_COUNT__SHIFT                                                       0x0
#define CP_DE_LAST_INVAL_COUNT__LAST_INVAL_COUNT_MASK                                                         0xFFFFFFFFL
//CP_DE_DE_COUNT
#define CP_DE_DE_COUNT__DRAW_ENGINE_COUNT__SHIFT                                                              0x0
#define CP_DE_DE_COUNT__DRAW_ENGINE_COUNT_MASK                                                                0xFFFFFFFFL
//CP_STALLED_STAT3
#define CP_STALLED_STAT3__CE_TO_CSF_NOT_RDY_TO_RCV__SHIFT                                                     0x0
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV__SHIFT                                        0x1
#define CP_STALLED_STAT3__CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER__SHIFT                                     0x2
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_NOT_RDY__SHIFT                                                       0x3
#define CP_STALLED_STAT3__CE_TO_RAM_DUMP_NOT_RDY__SHIFT                                                       0x4
#define CP_STALLED_STAT3__CE_TO_RAM_WRITE_NOT_RDY__SHIFT                                                      0x5
#define CP_STALLED_STAT3__CE_TO_INC_FIFO_NOT_RDY_TO_RCV__SHIFT                                                0x6
#define CP_STALLED_STAT3__CE_TO_WR_FIFO_NOT_RDY_TO_RCV__SHIFT                                                 0x7
#define CP_STALLED_STAT3__CE_WAITING_ON_BUFFER_DATA__SHIFT                                                    0xa
#define CP_STALLED_STAT3__CE_WAITING_ON_CE_BUFFER_FLAG__SHIFT                                                 0xb
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER__SHIFT                                                     0xc
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_UNDERFLOW__SHIFT                                           0xd
#define CP_STALLED_STAT3__TCIU_WAITING_ON_FREE__SHIFT                                                         0xe
#define CP_STALLED_STAT3__TCIU_WAITING_ON_TAGS__SHIFT                                                         0xf
#define CP_STALLED_STAT3__CE_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                  0x10
#define CP_STALLED_STAT3__CE_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                                0x11
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_FREE__SHIFT                                                      0x12
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                      0x13
#define CP_STALLED_STAT3__UTCL1_WAITING_ON_TRANS__SHIFT                                                       0x14
#define CP_STALLED_STAT3__CE_TO_CSF_NOT_RDY_TO_RCV_MASK                                                       0x00000001L
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV_MASK                                          0x00000002L
#define CP_STALLED_STAT3__CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER_MASK                                       0x00000004L
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_NOT_RDY_MASK                                                         0x00000008L
#define CP_STALLED_STAT3__CE_TO_RAM_DUMP_NOT_RDY_MASK                                                         0x00000010L
#define CP_STALLED_STAT3__CE_TO_RAM_WRITE_NOT_RDY_MASK                                                        0x00000020L
#define CP_STALLED_STAT3__CE_TO_INC_FIFO_NOT_RDY_TO_RCV_MASK                                                  0x00000040L
#define CP_STALLED_STAT3__CE_TO_WR_FIFO_NOT_RDY_TO_RCV_MASK                                                   0x00000080L
#define CP_STALLED_STAT3__CE_WAITING_ON_BUFFER_DATA_MASK                                                      0x00000400L
#define CP_STALLED_STAT3__CE_WAITING_ON_CE_BUFFER_FLAG_MASK                                                   0x00000800L
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_MASK                                                       0x00001000L
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_UNDERFLOW_MASK                                             0x00002000L
#define CP_STALLED_STAT3__TCIU_WAITING_ON_FREE_MASK                                                           0x00004000L
#define CP_STALLED_STAT3__TCIU_WAITING_ON_TAGS_MASK                                                           0x00008000L
#define CP_STALLED_STAT3__CE_STALLED_ON_TC_WR_CONFIRM_MASK                                                    0x00010000L
#define CP_STALLED_STAT3__CE_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                  0x00020000L
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_FREE_MASK                                                        0x00040000L
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_TAGS_MASK                                                        0x00080000L
#define CP_STALLED_STAT3__UTCL1_WAITING_ON_TRANS_MASK                                                         0x00100000L
//CP_STALLED_STAT1
#define CP_STALLED_STAT1__RBIU_TO_DMA_NOT_RDY_TO_RCV__SHIFT                                                   0x0
#define CP_STALLED_STAT1__RBIU_TO_SEM_NOT_RDY_TO_RCV__SHIFT                                                   0x2
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV__SHIFT                                                 0x4
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_CE_BUFFER_FLAG__SHIFT                                                 0xa
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_DE_BUFFER_FLAG__SHIFT                                                 0xb
#define CP_STALLED_STAT1__ME_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                  0xc
#define CP_STALLED_STAT1__ME_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                                0xd
#define CP_STALLED_STAT1__ME_WAITING_ON_TC_READ_DATA__SHIFT                                                   0xe
#define CP_STALLED_STAT1__ME_WAITING_ON_REG_READ_DATA__SHIFT                                                  0xf
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GDS_FREE__SHIFT                                                     0x17
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GRBM_FREE__SHIFT                                                    0x18
#define CP_STALLED_STAT1__RCIU_WAITING_ON_VGT_FREE__SHIFT                                                     0x19
#define CP_STALLED_STAT1__RCIU_STALLED_ON_ME_READ__SHIFT                                                      0x1a
#define CP_STALLED_STAT1__RCIU_STALLED_ON_DMA_READ__SHIFT                                                     0x1b
#define CP_STALLED_STAT1__RCIU_STALLED_ON_APPEND_READ__SHIFT                                                  0x1c
#define CP_STALLED_STAT1__RCIU_HALTED_BY_REG_VIOLATION__SHIFT                                                 0x1d
#define CP_STALLED_STAT1__RBIU_TO_DMA_NOT_RDY_TO_RCV_MASK                                                     0x00000001L
#define CP_STALLED_STAT1__RBIU_TO_SEM_NOT_RDY_TO_RCV_MASK                                                     0x00000004L
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV_MASK                                                   0x00000010L
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_CE_BUFFER_FLAG_MASK                                                   0x00000400L
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_DE_BUFFER_FLAG_MASK                                                   0x00000800L
#define CP_STALLED_STAT1__ME_STALLED_ON_TC_WR_CONFIRM_MASK                                                    0x00001000L
#define CP_STALLED_STAT1__ME_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                  0x00002000L
#define CP_STALLED_STAT1__ME_WAITING_ON_TC_READ_DATA_MASK                                                     0x00004000L
#define CP_STALLED_STAT1__ME_WAITING_ON_REG_READ_DATA_MASK                                                    0x00008000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GDS_FREE_MASK                                                       0x00800000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GRBM_FREE_MASK                                                      0x01000000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_VGT_FREE_MASK                                                       0x02000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_ME_READ_MASK                                                        0x04000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_DMA_READ_MASK                                                       0x08000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_APPEND_READ_MASK                                                    0x10000000L
#define CP_STALLED_STAT1__RCIU_HALTED_BY_REG_VIOLATION_MASK                                                   0x20000000L
//CP_STALLED_STAT2
#define CP_STALLED_STAT2__PFP_TO_CSF_NOT_RDY_TO_RCV__SHIFT                                                    0x0
#define CP_STALLED_STAT2__PFP_TO_MEQ_NOT_RDY_TO_RCV__SHIFT                                                    0x1
#define CP_STALLED_STAT2__PFP_TO_RCIU_NOT_RDY_TO_RCV__SHIFT                                                   0x2
#define CP_STALLED_STAT2__PFP_TO_VGT_WRITES_PENDING__SHIFT                                                    0x4
#define CP_STALLED_STAT2__PFP_RCIU_READ_PENDING__SHIFT                                                        0x5
#define CP_STALLED_STAT2__PFP_WAITING_ON_BUFFER_DATA__SHIFT                                                   0x8
#define CP_STALLED_STAT2__ME_WAIT_ON_CE_COUNTER__SHIFT                                                        0x9
#define CP_STALLED_STAT2__ME_WAIT_ON_AVAIL_BUFFER__SHIFT                                                      0xa
#define CP_STALLED_STAT2__GFX_CNTX_NOT_AVAIL_TO_ME__SHIFT                                                     0xb
#define CP_STALLED_STAT2__ME_RCIU_NOT_RDY_TO_RCV__SHIFT                                                       0xc
#define CP_STALLED_STAT2__ME_TO_CONST_NOT_RDY_TO_RCV__SHIFT                                                   0xd
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_PFP__SHIFT                                                     0xe
#define CP_STALLED_STAT2__ME_WAITING_ON_PARTIAL_FLUSH__SHIFT                                                  0xf
#define CP_STALLED_STAT2__MEQ_TO_ME_NOT_RDY_TO_RCV__SHIFT                                                     0x10
#define CP_STALLED_STAT2__STQ_TO_ME_NOT_RDY_TO_RCV__SHIFT                                                     0x11
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_STQ__SHIFT                                                     0x12
#define CP_STALLED_STAT2__PFP_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                 0x13
#define CP_STALLED_STAT2__PFP_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                               0x14
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_SC_EOP_DONE__SHIFT                                                  0x15
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_WR_CONFIRM__SHIFT                                                   0x16
#define CP_STALLED_STAT2__STRMO_WR_OF_PRIM_DATA_PENDING__SHIFT                                                0x17
#define CP_STALLED_STAT2__PIPE_STATS_WR_DATA_PENDING__SHIFT                                                   0x18
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_CS_DONE__SHIFT                                                   0x19
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_PS_DONE__SHIFT                                                   0x1a
#define CP_STALLED_STAT2__APPEND_WAIT_ON_WR_CONFIRM__SHIFT                                                    0x1b
#define CP_STALLED_STAT2__APPEND_ACTIVE_PARTITION__SHIFT                                                      0x1c
#define CP_STALLED_STAT2__APPEND_WAITING_TO_SEND_MEMWRITE__SHIFT                                              0x1d
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_IDLE_CNTXS__SHIFT                                                   0x1e
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_ALL_CLEAN__SHIFT                                                    0x1f
#define CP_STALLED_STAT2__PFP_TO_CSF_NOT_RDY_TO_RCV_MASK                                                      0x00000001L
#define CP_STALLED_STAT2__PFP_TO_MEQ_NOT_RDY_TO_RCV_MASK                                                      0x00000002L
#define CP_STALLED_STAT2__PFP_TO_RCIU_NOT_RDY_TO_RCV_MASK                                                     0x00000004L
#define CP_STALLED_STAT2__PFP_TO_VGT_WRITES_PENDING_MASK                                                      0x00000010L
#define CP_STALLED_STAT2__PFP_RCIU_READ_PENDING_MASK                                                          0x00000020L
#define CP_STALLED_STAT2__PFP_WAITING_ON_BUFFER_DATA_MASK                                                     0x00000100L
#define CP_STALLED_STAT2__ME_WAIT_ON_CE_COUNTER_MASK                                                          0x00000200L
#define CP_STALLED_STAT2__ME_WAIT_ON_AVAIL_BUFFER_MASK                                                        0x00000400L
#define CP_STALLED_STAT2__GFX_CNTX_NOT_AVAIL_TO_ME_MASK                                                       0x00000800L
#define CP_STALLED_STAT2__ME_RCIU_NOT_RDY_TO_RCV_MASK                                                         0x00001000L
#define CP_STALLED_STAT2__ME_TO_CONST_NOT_RDY_TO_RCV_MASK                                                     0x00002000L
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_PFP_MASK                                                       0x00004000L
#define CP_STALLED_STAT2__ME_WAITING_ON_PARTIAL_FLUSH_MASK                                                    0x00008000L
#define CP_STALLED_STAT2__MEQ_TO_ME_NOT_RDY_TO_RCV_MASK                                                       0x00010000L
#define CP_STALLED_STAT2__STQ_TO_ME_NOT_RDY_TO_RCV_MASK                                                       0x00020000L
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_STQ_MASK                                                       0x00040000L
#define CP_STALLED_STAT2__PFP_STALLED_ON_TC_WR_CONFIRM_MASK                                                   0x00080000L
#define CP_STALLED_STAT2__PFP_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                 0x00100000L
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_SC_EOP_DONE_MASK                                                    0x00200000L
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_WR_CONFIRM_MASK                                                     0x00400000L
#define CP_STALLED_STAT2__STRMO_WR_OF_PRIM_DATA_PENDING_MASK                                                  0x00800000L
#define CP_STALLED_STAT2__PIPE_STATS_WR_DATA_PENDING_MASK                                                     0x01000000L
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_CS_DONE_MASK                                                     0x02000000L
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_PS_DONE_MASK                                                     0x04000000L
#define CP_STALLED_STAT2__APPEND_WAIT_ON_WR_CONFIRM_MASK                                                      0x08000000L
#define CP_STALLED_STAT2__APPEND_ACTIVE_PARTITION_MASK                                                        0x10000000L
#define CP_STALLED_STAT2__APPEND_WAITING_TO_SEND_MEMWRITE_MASK                                                0x20000000L
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_IDLE_CNTXS_MASK                                                     0x40000000L
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_ALL_CLEAN_MASK                                                      0x80000000L
//CP_BUSY_STAT
#define CP_BUSY_STAT__REG_BUS_FIFO_BUSY__SHIFT                                                                0x0
#define CP_BUSY_STAT__COHER_CNT_NEQ_ZERO__SHIFT                                                               0x6
#define CP_BUSY_STAT__PFP_PARSING_PACKETS__SHIFT                                                              0x7
#define CP_BUSY_STAT__ME_PARSING_PACKETS__SHIFT                                                               0x8
#define CP_BUSY_STAT__RCIU_PFP_BUSY__SHIFT                                                                    0x9
#define CP_BUSY_STAT__RCIU_ME_BUSY__SHIFT                                                                     0xa
#define CP_BUSY_STAT__SEM_CMDFIFO_NOT_EMPTY__SHIFT                                                            0xc
#define CP_BUSY_STAT__SEM_FAILED_AND_HOLDING__SHIFT                                                           0xd
#define CP_BUSY_STAT__SEM_POLLING_FOR_PASS__SHIFT                                                             0xe
#define CP_BUSY_STAT__GFX_CONTEXT_BUSY__SHIFT                                                                 0xf
#define CP_BUSY_STAT__ME_PARSER_BUSY__SHIFT                                                                   0x11
#define CP_BUSY_STAT__EOP_DONE_BUSY__SHIFT                                                                    0x12
#define CP_BUSY_STAT__STRM_OUT_BUSY__SHIFT                                                                    0x13
#define CP_BUSY_STAT__PIPE_STATS_BUSY__SHIFT                                                                  0x14
#define CP_BUSY_STAT__RCIU_CE_BUSY__SHIFT                                                                     0x15
#define CP_BUSY_STAT__CE_PARSING_PACKETS__SHIFT                                                               0x16
#define CP_BUSY_STAT__REG_BUS_FIFO_BUSY_MASK                                                                  0x00000001L
#define CP_BUSY_STAT__COHER_CNT_NEQ_ZERO_MASK                                                                 0x00000040L
#define CP_BUSY_STAT__PFP_PARSING_PACKETS_MASK                                                                0x00000080L
#define CP_BUSY_STAT__ME_PARSING_PACKETS_MASK                                                                 0x00000100L
#define CP_BUSY_STAT__RCIU_PFP_BUSY_MASK                                                                      0x00000200L
#define CP_BUSY_STAT__RCIU_ME_BUSY_MASK                                                                       0x00000400L
#define CP_BUSY_STAT__SEM_CMDFIFO_NOT_EMPTY_MASK                                                              0x00001000L
#define CP_BUSY_STAT__SEM_FAILED_AND_HOLDING_MASK                                                             0x00002000L
#define CP_BUSY_STAT__SEM_POLLING_FOR_PASS_MASK                                                               0x00004000L
#define CP_BUSY_STAT__GFX_CONTEXT_BUSY_MASK                                                                   0x00008000L
#define CP_BUSY_STAT__ME_PARSER_BUSY_MASK                                                                     0x00020000L
#define CP_BUSY_STAT__EOP_DONE_BUSY_MASK                                                                      0x00040000L
#define CP_BUSY_STAT__STRM_OUT_BUSY_MASK                                                                      0x00080000L
#define CP_BUSY_STAT__PIPE_STATS_BUSY_MASK                                                                    0x00100000L
#define CP_BUSY_STAT__RCIU_CE_BUSY_MASK                                                                       0x00200000L
#define CP_BUSY_STAT__CE_PARSING_PACKETS_MASK                                                                 0x00400000L
//CP_STAT
#define CP_STAT__ROQ_RING_BUSY__SHIFT                                                                         0x9
#define CP_STAT__ROQ_INDIRECT1_BUSY__SHIFT                                                                    0xa
#define CP_STAT__ROQ_INDIRECT2_BUSY__SHIFT                                                                    0xb
#define CP_STAT__ROQ_STATE_BUSY__SHIFT                                                                        0xc
#define CP_STAT__DC_BUSY__SHIFT                                                                               0xd
#define CP_STAT__UTCL2IU_BUSY__SHIFT                                                                          0xe
#define CP_STAT__PFP_BUSY__SHIFT                                                                              0xf
#define CP_STAT__MEQ_BUSY__SHIFT                                                                              0x10
#define CP_STAT__ME_BUSY__SHIFT                                                                               0x11
#define CP_STAT__QUERY_BUSY__SHIFT                                                                            0x12
#define CP_STAT__SEMAPHORE_BUSY__SHIFT                                                                        0x13
#define CP_STAT__INTERRUPT_BUSY__SHIFT                                                                        0x14
#define CP_STAT__SURFACE_SYNC_BUSY__SHIFT                                                                     0x15
#define CP_STAT__DMA_BUSY__SHIFT                                                                              0x16
#define CP_STAT__RCIU_BUSY__SHIFT                                                                             0x17
#define CP_STAT__SCRATCH_RAM_BUSY__SHIFT                                                                      0x18
#define CP_STAT__CE_BUSY__SHIFT                                                                               0x1a
#define CP_STAT__TCIU_BUSY__SHIFT                                                                             0x1b
#define CP_STAT__ROQ_CE_RING_BUSY__SHIFT                                                                      0x1c
#define CP_STAT__ROQ_CE_INDIRECT1_BUSY__SHIFT                                                                 0x1d
#define CP_STAT__ROQ_CE_INDIRECT2_BUSY__SHIFT                                                                 0x1e
#define CP_STAT__CP_BUSY__SHIFT                                                                               0x1f
#define CP_STAT__ROQ_RING_BUSY_MASK                                                                           0x00000200L
#define CP_STAT__ROQ_INDIRECT1_BUSY_MASK                                                                      0x00000400L
#define CP_STAT__ROQ_INDIRECT2_BUSY_MASK                                                                      0x00000800L
#define CP_STAT__ROQ_STATE_BUSY_MASK                                                                          0x00001000L
#define CP_STAT__DC_BUSY_MASK                                                                                 0x00002000L
#define CP_STAT__UTCL2IU_BUSY_MASK                                                                            0x00004000L
#define CP_STAT__PFP_BUSY_MASK                                                                                0x00008000L
#define CP_STAT__MEQ_BUSY_MASK                                                                                0x00010000L
#define CP_STAT__ME_BUSY_MASK                                                                                 0x00020000L
#define CP_STAT__QUERY_BUSY_MASK                                                                              0x00040000L
#define CP_STAT__SEMAPHORE_BUSY_MASK                                                                          0x00080000L
#define CP_STAT__INTERRUPT_BUSY_MASK                                                                          0x00100000L
#define CP_STAT__SURFACE_SYNC_BUSY_MASK                                                                       0x00200000L
#define CP_STAT__DMA_BUSY_MASK                                                                                0x00400000L
#define CP_STAT__RCIU_BUSY_MASK                                                                               0x00800000L
#define CP_STAT__SCRATCH_RAM_BUSY_MASK                                                                        0x01000000L
#define CP_STAT__CE_BUSY_MASK                                                                                 0x04000000L
#define CP_STAT__TCIU_BUSY_MASK                                                                               0x08000000L
#define CP_STAT__ROQ_CE_RING_BUSY_MASK                                                                        0x10000000L
#define CP_STAT__ROQ_CE_INDIRECT1_BUSY_MASK                                                                   0x20000000L
#define CP_STAT__ROQ_CE_INDIRECT2_BUSY_MASK                                                                   0x40000000L
#define CP_STAT__CP_BUSY_MASK                                                                                 0x80000000L
//CP_ME_HEADER_DUMP
#define CP_ME_HEADER_DUMP__ME_HEADER_DUMP__SHIFT                                                              0x0
#define CP_ME_HEADER_DUMP__ME_HEADER_DUMP_MASK                                                                0xFFFFFFFFL
//CP_PFP_HEADER_DUMP
#define CP_PFP_HEADER_DUMP__PFP_HEADER_DUMP__SHIFT                                                            0x0
#define CP_PFP_HEADER_DUMP__PFP_HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_GRBM_FREE_COUNT
#define CP_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                                 0x0
#define CP_GRBM_FREE_COUNT__FREE_COUNT_GDS__SHIFT                                                             0x8
#define CP_GRBM_FREE_COUNT__FREE_COUNT_PFP__SHIFT                                                             0x10
#define CP_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                                   0x0000003FL
#define CP_GRBM_FREE_COUNT__FREE_COUNT_GDS_MASK                                                               0x00003F00L
#define CP_GRBM_FREE_COUNT__FREE_COUNT_PFP_MASK                                                               0x003F0000L
//CP_CE_HEADER_DUMP
#define CP_CE_HEADER_DUMP__CE_HEADER_DUMP__SHIFT                                                              0x0
#define CP_CE_HEADER_DUMP__CE_HEADER_DUMP_MASK                                                                0xFFFFFFFFL
//CP_PFP_INSTR_PNTR
#define CP_PFP_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                  0x0
#define CP_PFP_INSTR_PNTR__INSTR_PNTR_MASK                                                                    0x0000FFFFL
//CP_ME_INSTR_PNTR
#define CP_ME_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                   0x0
#define CP_ME_INSTR_PNTR__INSTR_PNTR_MASK                                                                     0x0000FFFFL
//CP_CE_INSTR_PNTR
#define CP_CE_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                   0x0
#define CP_CE_INSTR_PNTR__INSTR_PNTR_MASK                                                                     0x0000FFFFL
//CP_MEC1_INSTR_PNTR
#define CP_MEC1_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                 0x0
#define CP_MEC1_INSTR_PNTR__INSTR_PNTR_MASK                                                                   0x0000FFFFL
//CP_MEC2_INSTR_PNTR
#define CP_MEC2_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                 0x0
#define CP_MEC2_INSTR_PNTR__INSTR_PNTR_MASK                                                                   0x0000FFFFL
//CP_CSF_STAT
#define CP_CSF_STAT__BUFFER_REQUEST_COUNT__SHIFT                                                              0x8
#define CP_CSF_STAT__BUFFER_REQUEST_COUNT_MASK                                                                0x0001FF00L
//CP_ME_CNTL
#define CP_ME_CNTL__CE_INVALIDATE_ICACHE__SHIFT                                                               0x4
#define CP_ME_CNTL__PFP_INVALIDATE_ICACHE__SHIFT                                                              0x6
#define CP_ME_CNTL__ME_INVALIDATE_ICACHE__SHIFT                                                               0x8
#define CP_ME_CNTL__CE_PIPE0_RESET__SHIFT                                                                     0x10
#define CP_ME_CNTL__CE_PIPE1_RESET__SHIFT                                                                     0x11
#define CP_ME_CNTL__PFP_PIPE0_RESET__SHIFT                                                                    0x12
#define CP_ME_CNTL__PFP_PIPE1_RESET__SHIFT                                                                    0x13
#define CP_ME_CNTL__ME_PIPE0_RESET__SHIFT                                                                     0x14
#define CP_ME_CNTL__ME_PIPE1_RESET__SHIFT                                                                     0x15
#define CP_ME_CNTL__CE_HALT__SHIFT                                                                            0x18
#define CP_ME_CNTL__CE_STEP__SHIFT                                                                            0x19
#define CP_ME_CNTL__PFP_HALT__SHIFT                                                                           0x1a
#define CP_ME_CNTL__PFP_STEP__SHIFT                                                                           0x1b
#define CP_ME_CNTL__ME_HALT__SHIFT                                                                            0x1c
#define CP_ME_CNTL__ME_STEP__SHIFT                                                                            0x1d
#define CP_ME_CNTL__CE_INVALIDATE_ICACHE_MASK                                                                 0x00000010L
#define CP_ME_CNTL__PFP_INVALIDATE_ICACHE_MASK                                                                0x00000040L
#define CP_ME_CNTL__ME_INVALIDATE_ICACHE_MASK                                                                 0x00000100L
#define CP_ME_CNTL__CE_PIPE0_RESET_MASK                                                                       0x00010000L
#define CP_ME_CNTL__CE_PIPE1_RESET_MASK                                                                       0x00020000L
#define CP_ME_CNTL__PFP_PIPE0_RESET_MASK                                                                      0x00040000L
#define CP_ME_CNTL__PFP_PIPE1_RESET_MASK                                                                      0x00080000L
#define CP_ME_CNTL__ME_PIPE0_RESET_MASK                                                                       0x00100000L
#define CP_ME_CNTL__ME_PIPE1_RESET_MASK                                                                       0x00200000L
#define CP_ME_CNTL__CE_HALT_MASK                                                                              0x01000000L
#define CP_ME_CNTL__CE_STEP_MASK                                                                              0x02000000L
#define CP_ME_CNTL__PFP_HALT_MASK                                                                             0x04000000L
#define CP_ME_CNTL__PFP_STEP_MASK                                                                             0x08000000L
#define CP_ME_CNTL__ME_HALT_MASK                                                                              0x10000000L
#define CP_ME_CNTL__ME_STEP_MASK                                                                              0x20000000L
//CP_CNTX_STAT
#define CP_CNTX_STAT__ACTIVE_HP3D_CONTEXTS__SHIFT                                                             0x0
#define CP_CNTX_STAT__CURRENT_HP3D_CONTEXT__SHIFT                                                             0x8
#define CP_CNTX_STAT__ACTIVE_GFX_CONTEXTS__SHIFT                                                              0x14
#define CP_CNTX_STAT__CURRENT_GFX_CONTEXT__SHIFT                                                              0x1c
#define CP_CNTX_STAT__ACTIVE_HP3D_CONTEXTS_MASK                                                               0x000000FFL
#define CP_CNTX_STAT__CURRENT_HP3D_CONTEXT_MASK                                                               0x00000700L
#define CP_CNTX_STAT__ACTIVE_GFX_CONTEXTS_MASK                                                                0x0FF00000L
#define CP_CNTX_STAT__CURRENT_GFX_CONTEXT_MASK                                                                0x70000000L
//CP_ME_PREEMPTION
#define CP_ME_PREEMPTION__OBSOLETE__SHIFT                                                                     0x0
#define CP_ME_PREEMPTION__OBSOLETE_MASK                                                                       0x00000001L
//CP_ROQ_THRESHOLDS
#define CP_ROQ_THRESHOLDS__IB1_START__SHIFT                                                                   0x0
#define CP_ROQ_THRESHOLDS__IB2_START__SHIFT                                                                   0x8
#define CP_ROQ_THRESHOLDS__IB1_START_MASK                                                                     0x000000FFL
#define CP_ROQ_THRESHOLDS__IB2_START_MASK                                                                     0x0000FF00L
//CP_MEQ_STQ_THRESHOLD
#define CP_MEQ_STQ_THRESHOLD__STQ_START__SHIFT                                                                0x0
#define CP_MEQ_STQ_THRESHOLD__STQ_START_MASK                                                                  0x000000FFL
//CP_RB2_RPTR
#define CP_RB2_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB2_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB1_RPTR
#define CP_RB1_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB1_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB0_RPTR
#define CP_RB0_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB0_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB_RPTR
#define CP_RB_RPTR__RB_RPTR__SHIFT                                                                            0x0
#define CP_RB_RPTR__RB_RPTR_MASK                                                                              0x000FFFFFL
//CP_RB_WPTR_DELAY
#define CP_RB_WPTR_DELAY__PRE_WRITE_TIMER__SHIFT                                                              0x0
#define CP_RB_WPTR_DELAY__PRE_WRITE_LIMIT__SHIFT                                                              0x1c
#define CP_RB_WPTR_DELAY__PRE_WRITE_TIMER_MASK                                                                0x0FFFFFFFL
#define CP_RB_WPTR_DELAY__PRE_WRITE_LIMIT_MASK                                                                0xF0000000L
//CP_RB_WPTR_POLL_CNTL
#define CP_RB_WPTR_POLL_CNTL__POLL_FREQUENCY__SHIFT                                                           0x0
#define CP_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                          0x10
#define CP_RB_WPTR_POLL_CNTL__POLL_FREQUENCY_MASK                                                             0x0000FFFFL
#define CP_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                            0xFFFF0000L
//CP_ROQ1_THRESHOLDS
#define CP_ROQ1_THRESHOLDS__RB1_START__SHIFT                                                                  0x0
#define CP_ROQ1_THRESHOLDS__RB2_START__SHIFT                                                                  0x8
#define CP_ROQ1_THRESHOLDS__R0_IB1_START__SHIFT                                                               0x10
#define CP_ROQ1_THRESHOLDS__R1_IB1_START__SHIFT                                                               0x18
#define CP_ROQ1_THRESHOLDS__RB1_START_MASK                                                                    0x000000FFL
#define CP_ROQ1_THRESHOLDS__RB2_START_MASK                                                                    0x0000FF00L
#define CP_ROQ1_THRESHOLDS__R0_IB1_START_MASK                                                                 0x00FF0000L
#define CP_ROQ1_THRESHOLDS__R1_IB1_START_MASK                                                                 0xFF000000L
//CP_ROQ2_THRESHOLDS
#define CP_ROQ2_THRESHOLDS__R2_IB1_START__SHIFT                                                               0x0
#define CP_ROQ2_THRESHOLDS__R0_IB2_START__SHIFT                                                               0x8
#define CP_ROQ2_THRESHOLDS__R1_IB2_START__SHIFT                                                               0x10
#define CP_ROQ2_THRESHOLDS__R2_IB2_START__SHIFT                                                               0x18
#define CP_ROQ2_THRESHOLDS__R2_IB1_START_MASK                                                                 0x000000FFL
#define CP_ROQ2_THRESHOLDS__R0_IB2_START_MASK                                                                 0x0000FF00L
#define CP_ROQ2_THRESHOLDS__R1_IB2_START_MASK                                                                 0x00FF0000L
#define CP_ROQ2_THRESHOLDS__R2_IB2_START_MASK                                                                 0xFF000000L
//CP_STQ_THRESHOLDS
#define CP_STQ_THRESHOLDS__STQ0_START__SHIFT                                                                  0x0
#define CP_STQ_THRESHOLDS__STQ1_START__SHIFT                                                                  0x8
#define CP_STQ_THRESHOLDS__STQ2_START__SHIFT                                                                  0x10
#define CP_STQ_THRESHOLDS__STQ0_START_MASK                                                                    0x000000FFL
#define CP_STQ_THRESHOLDS__STQ1_START_MASK                                                                    0x0000FF00L
#define CP_STQ_THRESHOLDS__STQ2_START_MASK                                                                    0x00FF0000L
//CP_QUEUE_THRESHOLDS
#define CP_QUEUE_THRESHOLDS__ROQ_IB1_START__SHIFT                                                             0x0
#define CP_QUEUE_THRESHOLDS__ROQ_IB2_START__SHIFT                                                             0x8
#define CP_QUEUE_THRESHOLDS__ROQ_IB1_START_MASK                                                               0x0000003FL
#define CP_QUEUE_THRESHOLDS__ROQ_IB2_START_MASK                                                               0x00003F00L
//CP_MEQ_THRESHOLDS
#define CP_MEQ_THRESHOLDS__MEQ1_START__SHIFT                                                                  0x0
#define CP_MEQ_THRESHOLDS__MEQ2_START__SHIFT                                                                  0x8
#define CP_MEQ_THRESHOLDS__MEQ1_START_MASK                                                                    0x000000FFL
#define CP_MEQ_THRESHOLDS__MEQ2_START_MASK                                                                    0x0000FF00L
//CP_ROQ_AVAIL
#define CP_ROQ_AVAIL__ROQ_CNT_RING__SHIFT                                                                     0x0
#define CP_ROQ_AVAIL__ROQ_CNT_IB1__SHIFT                                                                      0x10
#define CP_ROQ_AVAIL__ROQ_CNT_RING_MASK                                                                       0x000007FFL
#define CP_ROQ_AVAIL__ROQ_CNT_IB1_MASK                                                                        0x07FF0000L
//CP_STQ_AVAIL
#define CP_STQ_AVAIL__STQ_CNT__SHIFT                                                                          0x0
#define CP_STQ_AVAIL__STQ_CNT_MASK                                                                            0x000001FFL
//CP_ROQ2_AVAIL
#define CP_ROQ2_AVAIL__ROQ_CNT_IB2__SHIFT                                                                     0x0
#define CP_ROQ2_AVAIL__ROQ_CNT_IB2_MASK                                                                       0x000007FFL
//CP_MEQ_AVAIL
#define CP_MEQ_AVAIL__MEQ_CNT__SHIFT                                                                          0x0
#define CP_MEQ_AVAIL__MEQ_CNT_MASK                                                                            0x000003FFL
//CP_CMD_INDEX
#define CP_CMD_INDEX__CMD_INDEX__SHIFT                                                                        0x0
#define CP_CMD_INDEX__CMD_ME_SEL__SHIFT                                                                       0xc
#define CP_CMD_INDEX__CMD_QUEUE_SEL__SHIFT                                                                    0x10
#define CP_CMD_INDEX__CMD_INDEX_MASK                                                                          0x000007FFL
#define CP_CMD_INDEX__CMD_ME_SEL_MASK                                                                         0x00003000L
#define CP_CMD_INDEX__CMD_QUEUE_SEL_MASK                                                                      0x00070000L
//CP_CMD_DATA
#define CP_CMD_DATA__CMD_DATA__SHIFT                                                                          0x0
#define CP_CMD_DATA__CMD_DATA_MASK                                                                            0xFFFFFFFFL
//CP_ROQ_RB_STAT
#define CP_ROQ_RB_STAT__ROQ_RPTR_PRIMARY__SHIFT                                                               0x0
#define CP_ROQ_RB_STAT__ROQ_WPTR_PRIMARY__SHIFT                                                               0x10
#define CP_ROQ_RB_STAT__ROQ_RPTR_PRIMARY_MASK                                                                 0x000003FFL
#define CP_ROQ_RB_STAT__ROQ_WPTR_PRIMARY_MASK                                                                 0x03FF0000L
//CP_ROQ_IB1_STAT
#define CP_ROQ_IB1_STAT__ROQ_RPTR_INDIRECT1__SHIFT                                                            0x0
#define CP_ROQ_IB1_STAT__ROQ_WPTR_INDIRECT1__SHIFT                                                            0x10
#define CP_ROQ_IB1_STAT__ROQ_RPTR_INDIRECT1_MASK                                                              0x000003FFL
#define CP_ROQ_IB1_STAT__ROQ_WPTR_INDIRECT1_MASK                                                              0x03FF0000L
//CP_ROQ_IB2_STAT
#define CP_ROQ_IB2_STAT__ROQ_RPTR_INDIRECT2__SHIFT                                                            0x0
#define CP_ROQ_IB2_STAT__ROQ_WPTR_INDIRECT2__SHIFT                                                            0x10
#define CP_ROQ_IB2_STAT__ROQ_RPTR_INDIRECT2_MASK                                                              0x000003FFL
#define CP_ROQ_IB2_STAT__ROQ_WPTR_INDIRECT2_MASK                                                              0x03FF0000L
//CP_STQ_STAT
#define CP_STQ_STAT__STQ_RPTR__SHIFT                                                                          0x0
#define CP_STQ_STAT__STQ_RPTR_MASK                                                                            0x000003FFL
//CP_STQ_WR_STAT
#define CP_STQ_WR_STAT__STQ_WPTR__SHIFT                                                                       0x0
#define CP_STQ_WR_STAT__STQ_WPTR_MASK                                                                         0x000003FFL
//CP_MEQ_STAT
#define CP_MEQ_STAT__MEQ_RPTR__SHIFT                                                                          0x0
#define CP_MEQ_STAT__MEQ_WPTR__SHIFT                                                                          0x10
#define CP_MEQ_STAT__MEQ_RPTR_MASK                                                                            0x000003FFL
#define CP_MEQ_STAT__MEQ_WPTR_MASK                                                                            0x03FF0000L
//CP_CEQ1_AVAIL
#define CP_CEQ1_AVAIL__CEQ_CNT_RING__SHIFT                                                                    0x0
#define CP_CEQ1_AVAIL__CEQ_CNT_IB1__SHIFT                                                                     0x10
#define CP_CEQ1_AVAIL__CEQ_CNT_RING_MASK                                                                      0x000007FFL
#define CP_CEQ1_AVAIL__CEQ_CNT_IB1_MASK                                                                       0x07FF0000L
//CP_CEQ2_AVAIL
#define CP_CEQ2_AVAIL__CEQ_CNT_IB2__SHIFT                                                                     0x0
#define CP_CEQ2_AVAIL__CEQ_CNT_IB2_MASK                                                                       0x000007FFL
//CP_CE_ROQ_RB_STAT
#define CP_CE_ROQ_RB_STAT__CEQ_RPTR_PRIMARY__SHIFT                                                            0x0
#define CP_CE_ROQ_RB_STAT__CEQ_WPTR_PRIMARY__SHIFT                                                            0x10
#define CP_CE_ROQ_RB_STAT__CEQ_RPTR_PRIMARY_MASK                                                              0x000003FFL
#define CP_CE_ROQ_RB_STAT__CEQ_WPTR_PRIMARY_MASK                                                              0x03FF0000L
//CP_CE_ROQ_IB1_STAT
#define CP_CE_ROQ_IB1_STAT__CEQ_RPTR_INDIRECT1__SHIFT                                                         0x0
#define CP_CE_ROQ_IB1_STAT__CEQ_WPTR_INDIRECT1__SHIFT                                                         0x10
#define CP_CE_ROQ_IB1_STAT__CEQ_RPTR_INDIRECT1_MASK                                                           0x000003FFL
#define CP_CE_ROQ_IB1_STAT__CEQ_WPTR_INDIRECT1_MASK                                                           0x03FF0000L
//CP_CE_ROQ_IB2_STAT
#define CP_CE_ROQ_IB2_STAT__CEQ_RPTR_INDIRECT2__SHIFT                                                         0x0
#define CP_CE_ROQ_IB2_STAT__CEQ_WPTR_INDIRECT2__SHIFT                                                         0x10
#define CP_CE_ROQ_IB2_STAT__CEQ_RPTR_INDIRECT2_MASK                                                           0x000003FFL
#define CP_CE_ROQ_IB2_STAT__CEQ_WPTR_INDIRECT2_MASK                                                           0x03FF0000L
#define CP_INT_STAT_DEBUG__PRIV_INSTR_INT_ASSERTED__SHIFT                                                     0x16
#define CP_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED__SHIFT                                                       0x17
#define CP_INT_STAT_DEBUG__PRIV_INSTR_INT_ASSERTED_MASK                                                       0x00400000L
#define CP_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED_MASK                                                         0x00800000L


// addressBlock: gc_padec
//VGT_VTX_VECT_EJECT_REG
#define VGT_VTX_VECT_EJECT_REG__PRIM_COUNT__SHIFT                                                             0x0
#define VGT_VTX_VECT_EJECT_REG__PRIM_COUNT_MASK                                                               0x0000007FL
//VGT_DMA_DATA_FIFO_DEPTH
#define VGT_DMA_DATA_FIFO_DEPTH__DMA_DATA_FIFO_DEPTH__SHIFT                                                   0x0
#define VGT_DMA_DATA_FIFO_DEPTH__DMA2DRAW_FIFO_DEPTH__SHIFT                                                   0x9
#define VGT_DMA_DATA_FIFO_DEPTH__DMA_DATA_FIFO_DEPTH_MASK                                                     0x000001FFL
#define VGT_DMA_DATA_FIFO_DEPTH__DMA2DRAW_FIFO_DEPTH_MASK                                                     0x0007FE00L
//VGT_DMA_REQ_FIFO_DEPTH
#define VGT_DMA_REQ_FIFO_DEPTH__DMA_REQ_FIFO_DEPTH__SHIFT                                                     0x0
#define VGT_DMA_REQ_FIFO_DEPTH__DMA_REQ_FIFO_DEPTH_MASK                                                       0x0000003FL
//VGT_DRAW_INIT_FIFO_DEPTH
#define VGT_DRAW_INIT_FIFO_DEPTH__DRAW_INIT_FIFO_DEPTH__SHIFT                                                 0x0
#define VGT_DRAW_INIT_FIFO_DEPTH__DRAW_INIT_FIFO_DEPTH_MASK                                                   0x0000003FL
//VGT_LAST_COPY_STATE
#define VGT_LAST_COPY_STATE__SRC_STATE_ID__SHIFT                                                              0x0
#define VGT_LAST_COPY_STATE__DST_STATE_ID__SHIFT                                                              0x10
#define VGT_LAST_COPY_STATE__SRC_STATE_ID_MASK                                                                0x00000007L
#define VGT_LAST_COPY_STATE__DST_STATE_ID_MASK                                                                0x00070000L
//VGT_CACHE_INVALIDATION
#define VGT_CACHE_INVALIDATION__CACHE_INVALIDATION__SHIFT                                                     0x0
#define VGT_CACHE_INVALIDATION__DIS_INSTANCING_OPT__SHIFT                                                     0x4
#define VGT_CACHE_INVALIDATION__VS_NO_EXTRA_BUFFER__SHIFT                                                     0x5
#define VGT_CACHE_INVALIDATION__AUTO_INVLD_EN__SHIFT                                                          0x6
#define VGT_CACHE_INVALIDATION__USE_GS_DONE__SHIFT                                                            0x9
#define VGT_CACHE_INVALIDATION__DIS_RANGE_FULL_INVLD__SHIFT                                                   0xb
#define VGT_CACHE_INVALIDATION__GS_LATE_ALLOC_EN__SHIFT                                                       0xc
#define VGT_CACHE_INVALIDATION__STREAMOUT_FULL_FLUSH__SHIFT                                                   0xd
#define VGT_CACHE_INVALIDATION__ES_LIMIT__SHIFT                                                               0x10
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG__SHIFT                                                       0x15
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_1__SHIFT                                                        0x16
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_2__SHIFT                                                        0x19
#define VGT_CACHE_INVALIDATION__EN_WAVE_MERGE__SHIFT                                                          0x1c
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG_EOI__SHIFT                                                   0x1d
#define VGT_CACHE_INVALIDATION__CACHE_INVALIDATION_MASK                                                       0x00000003L
#define VGT_CACHE_INVALIDATION__DIS_INSTANCING_OPT_MASK                                                       0x00000010L
#define VGT_CACHE_INVALIDATION__VS_NO_EXTRA_BUFFER_MASK                                                       0x00000020L
#define VGT_CACHE_INVALIDATION__AUTO_INVLD_EN_MASK                                                            0x000000C0L
#define VGT_CACHE_INVALIDATION__USE_GS_DONE_MASK                                                              0x00000200L
#define VGT_CACHE_INVALIDATION__DIS_RANGE_FULL_INVLD_MASK                                                     0x00000800L
#define VGT_CACHE_INVALIDATION__GS_LATE_ALLOC_EN_MASK                                                         0x00001000L
#define VGT_CACHE_INVALIDATION__STREAMOUT_FULL_FLUSH_MASK                                                     0x00002000L
#define VGT_CACHE_INVALIDATION__ES_LIMIT_MASK                                                                 0x001F0000L
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG_MASK                                                         0x00200000L
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_1_MASK                                                          0x01C00000L
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_2_MASK                                                          0x0E000000L
#define VGT_CACHE_INVALIDATION__EN_WAVE_MERGE_MASK                                                            0x10000000L
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG_EOI_MASK                                                     0x20000000L
//VGT_STRMOUT_DELAY
#define VGT_STRMOUT_DELAY__SKIP_DELAY__SHIFT                                                                  0x0
#define VGT_STRMOUT_DELAY__SE0_WD_DELAY__SHIFT                                                                0x8
#define VGT_STRMOUT_DELAY__SE1_WD_DELAY__SHIFT                                                                0xb
#define VGT_STRMOUT_DELAY__SE2_WD_DELAY__SHIFT                                                                0xe
#define VGT_STRMOUT_DELAY__SE3_WD_DELAY__SHIFT                                                                0x11
#define VGT_STRMOUT_DELAY__SKIP_DELAY_MASK                                                                    0x000000FFL
#define VGT_STRMOUT_DELAY__SE0_WD_DELAY_MASK                                                                  0x00000700L
#define VGT_STRMOUT_DELAY__SE1_WD_DELAY_MASK                                                                  0x00003800L
#define VGT_STRMOUT_DELAY__SE2_WD_DELAY_MASK                                                                  0x0001C000L
#define VGT_STRMOUT_DELAY__SE3_WD_DELAY_MASK                                                                  0x000E0000L
//VGT_FIFO_DEPTHS
#define VGT_FIFO_DEPTHS__VS_DEALLOC_TBL_DEPTH__SHIFT                                                          0x0
#define VGT_FIFO_DEPTHS__RESERVED_0__SHIFT                                                                    0x7
#define VGT_FIFO_DEPTHS__CLIPP_FIFO_DEPTH__SHIFT                                                              0x8
#define VGT_FIFO_DEPTHS__HSINPUT_FIFO_DEPTH__SHIFT                                                            0x16
#define VGT_FIFO_DEPTHS__VS_DEALLOC_TBL_DEPTH_MASK                                                            0x0000007FL
#define VGT_FIFO_DEPTHS__RESERVED_0_MASK                                                                      0x00000080L
#define VGT_FIFO_DEPTHS__CLIPP_FIFO_DEPTH_MASK                                                                0x003FFF00L
#define VGT_FIFO_DEPTHS__HSINPUT_FIFO_DEPTH_MASK                                                              0x0FC00000L
//VGT_GS_VERTEX_REUSE
#define VGT_GS_VERTEX_REUSE__VERT_REUSE__SHIFT                                                                0x0
#define VGT_GS_VERTEX_REUSE__VERT_REUSE_MASK                                                                  0x0000001FL
//VGT_MC_LAT_CNTL
#define VGT_MC_LAT_CNTL__MC_TIME_STAMP_RES__SHIFT                                                             0x0
#define VGT_MC_LAT_CNTL__MC_TIME_STAMP_RES_MASK                                                               0x0000000FL
//IA_CNTL_STATUS
#define IA_CNTL_STATUS__IA_BUSY__SHIFT                                                                        0x0
#define IA_CNTL_STATUS__IA_DMA_BUSY__SHIFT                                                                    0x1
#define IA_CNTL_STATUS__IA_DMA_REQ_BUSY__SHIFT                                                                0x2
#define IA_CNTL_STATUS__IA_GRP_BUSY__SHIFT                                                                    0x3
#define IA_CNTL_STATUS__IA_ADC_BUSY__SHIFT                                                                    0x4
#define IA_CNTL_STATUS__IA_BUSY_MASK                                                                          0x00000001L
#define IA_CNTL_STATUS__IA_DMA_BUSY_MASK                                                                      0x00000002L
#define IA_CNTL_STATUS__IA_DMA_REQ_BUSY_MASK                                                                  0x00000004L
#define IA_CNTL_STATUS__IA_GRP_BUSY_MASK                                                                      0x00000008L
#define IA_CNTL_STATUS__IA_ADC_BUSY_MASK                                                                      0x00000010L
//VGT_CNTL_STATUS
#define VGT_CNTL_STATUS__VGT_BUSY__SHIFT                                                                      0x0
#define VGT_CNTL_STATUS__VGT_OUT_INDX_BUSY__SHIFT                                                             0x1
#define VGT_CNTL_STATUS__VGT_OUT_BUSY__SHIFT                                                                  0x2
#define VGT_CNTL_STATUS__VGT_PT_BUSY__SHIFT                                                                   0x3
#define VGT_CNTL_STATUS__VGT_TE_BUSY__SHIFT                                                                   0x4
#define VGT_CNTL_STATUS__VGT_VR_BUSY__SHIFT                                                                   0x5
#define VGT_CNTL_STATUS__VGT_PI_BUSY__SHIFT                                                                   0x6
#define VGT_CNTL_STATUS__VGT_GS_BUSY__SHIFT                                                                   0x7
#define VGT_CNTL_STATUS__VGT_HS_BUSY__SHIFT                                                                   0x8
#define VGT_CNTL_STATUS__VGT_TE11_BUSY__SHIFT                                                                 0x9
#define VGT_CNTL_STATUS__VGT_PRIMGEN_BUSY__SHIFT                                                              0xa
#define VGT_CNTL_STATUS__VGT_BUSY_MASK                                                                        0x00000001L
#define VGT_CNTL_STATUS__VGT_OUT_INDX_BUSY_MASK                                                               0x00000002L
#define VGT_CNTL_STATUS__VGT_OUT_BUSY_MASK                                                                    0x00000004L
#define VGT_CNTL_STATUS__VGT_PT_BUSY_MASK                                                                     0x00000008L
#define VGT_CNTL_STATUS__VGT_TE_BUSY_MASK                                                                     0x00000010L
#define VGT_CNTL_STATUS__VGT_VR_BUSY_MASK                                                                     0x00000020L
#define VGT_CNTL_STATUS__VGT_PI_BUSY_MASK                                                                     0x00000040L
#define VGT_CNTL_STATUS__VGT_GS_BUSY_MASK                                                                     0x00000080L
#define VGT_CNTL_STATUS__VGT_HS_BUSY_MASK                                                                     0x00000100L
#define VGT_CNTL_STATUS__VGT_TE11_BUSY_MASK                                                                   0x00000200L
#define VGT_CNTL_STATUS__VGT_PRIMGEN_BUSY_MASK                                                                0x00000400L
//WD_CNTL_STATUS
#define WD_CNTL_STATUS__WD_BUSY__SHIFT                                                                        0x0
#define WD_CNTL_STATUS__WD_SPL_DMA_BUSY__SHIFT                                                                0x1
#define WD_CNTL_STATUS__WD_SPL_DI_BUSY__SHIFT                                                                 0x2
#define WD_CNTL_STATUS__WD_ADC_BUSY__SHIFT                                                                    0x3
#define WD_CNTL_STATUS__WD_BUSY_MASK                                                                          0x00000001L
#define WD_CNTL_STATUS__WD_SPL_DMA_BUSY_MASK                                                                  0x00000002L
#define WD_CNTL_STATUS__WD_SPL_DI_BUSY_MASK                                                                   0x00000004L
#define WD_CNTL_STATUS__WD_ADC_BUSY_MASK                                                                      0x00000008L
//CC_GC_PRIM_CONFIG
#define CC_GC_PRIM_CONFIG__INACTIVE_IA__SHIFT                                                                 0x10
#define CC_GC_PRIM_CONFIG__INACTIVE_VGT_PA__SHIFT                                                             0x18
#define CC_GC_PRIM_CONFIG__INACTIVE_IA_MASK                                                                   0x00030000L
#define CC_GC_PRIM_CONFIG__INACTIVE_VGT_PA_MASK                                                               0x0F000000L
//GC_USER_PRIM_CONFIG
#define GC_USER_PRIM_CONFIG__INACTIVE_IA__SHIFT                                                               0x10
#define GC_USER_PRIM_CONFIG__INACTIVE_VGT_PA__SHIFT                                                           0x18
#define GC_USER_PRIM_CONFIG__INACTIVE_IA_MASK                                                                 0x00030000L
#define GC_USER_PRIM_CONFIG__INACTIVE_VGT_PA_MASK                                                             0x0F000000L
//WD_QOS
#define WD_QOS__DRAW_STALL__SHIFT                                                                             0x0
#define WD_QOS__DRAW_STALL_MASK                                                                               0x00000001L
//WD_UTCL1_CNTL
#define WD_UTCL1_CNTL__XNACK_REDO_TIMER_CNT__SHIFT                                                            0x0
#define WD_UTCL1_CNTL__VMID_RESET_MODE__SHIFT                                                                 0x17
#define WD_UTCL1_CNTL__DROP_MODE__SHIFT                                                                       0x18
#define WD_UTCL1_CNTL__BYPASS__SHIFT                                                                          0x19
#define WD_UTCL1_CNTL__INVALIDATE__SHIFT                                                                      0x1a
#define WD_UTCL1_CNTL__FRAG_LIMIT_MODE__SHIFT                                                                 0x1b
#define WD_UTCL1_CNTL__FORCE_SNOOP__SHIFT                                                                     0x1c
#define WD_UTCL1_CNTL__FORCE_SD_VMID_DIRTY__SHIFT                                                             0x1d
#define WD_UTCL1_CNTL__XNACK_REDO_TIMER_CNT_MASK                                                              0x000FFFFFL
#define WD_UTCL1_CNTL__VMID_RESET_MODE_MASK                                                                   0x00800000L
#define WD_UTCL1_CNTL__DROP_MODE_MASK                                                                         0x01000000L
#define WD_UTCL1_CNTL__BYPASS_MASK                                