/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;

public final class AnnotatedTypeFactory {
    static final AnnotatedType EMPTY_ANNOTATED_TYPE = new AnnotatedTypeBaseImpl(null, TypeAnnotation.LocationInfo.BASE_LOCATION, new TypeAnnotation[0], new TypeAnnotation[0], null);
    static final AnnotatedType[] EMPTY_ANNOTATED_TYPE_ARRAY = new AnnotatedType[0];

    public static AnnotatedType buildAnnotatedType(Type type, TypeAnnotation.LocationInfo locationInfo, TypeAnnotation[] typeAnnotationArray, TypeAnnotation[] typeAnnotationArray2, AnnotatedElement annotatedElement) {
        if (type == null) {
            return EMPTY_ANNOTATED_TYPE;
        }
        if (AnnotatedTypeFactory.isArray(type)) {
            return new AnnotatedArrayTypeImpl(type, locationInfo, typeAnnotationArray, typeAnnotationArray2, annotatedElement);
        }
        if (type instanceof Class) {
            return new AnnotatedTypeBaseImpl(type, AnnotatedTypeFactory.addNesting(type, locationInfo), typeAnnotationArray, typeAnnotationArray2, annotatedElement);
        }
        if (type instanceof TypeVariable) {
            return new AnnotatedTypeVariableImpl((TypeVariable)type, locationInfo, typeAnnotationArray, typeAnnotationArray2, annotatedElement);
        }
        if (type instanceof ParameterizedType) {
            return new AnnotatedParameterizedTypeImpl((ParameterizedType)type, AnnotatedTypeFactory.addNesting(type, locationInfo), typeAnnotationArray, typeAnnotationArray2, annotatedElement);
        }
        if (type instanceof WildcardType) {
            return new AnnotatedWildcardTypeImpl((WildcardType)type, locationInfo, typeAnnotationArray, typeAnnotationArray2, annotatedElement);
        }
        throw new AssertionError((Object)("Unknown instance of Type: " + type + "\nThis should not happen."));
    }

    private static TypeAnnotation.LocationInfo addNesting(Type type, TypeAnnotation.LocationInfo locationInfo) {
        if (AnnotatedTypeFactory.isArray(type)) {
            return locationInfo;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.getEnclosingClass() == null) {
                return locationInfo;
            }
            if (Modifier.isStatic(clazz.getModifiers())) {
                return AnnotatedTypeFactory.addNesting(clazz.getEnclosingClass(), locationInfo);
            }
            return AnnotatedTypeFactory.addNesting(clazz.getEnclosingClass(), locationInfo.pushInner());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getOwnerType() == null) {
                return locationInfo;
            }
            return AnnotatedTypeFactory.addNesting(parameterizedType.getOwnerType(), locationInfo.pushInner());
        }
        return locationInfo;
    }

    private static boolean isArray(Type type) {
        Class clazz;
        return type instanceof Class ? (clazz = (Class)type).isArray() : type instanceof GenericArrayType;
    }

    private static final class AnnotatedWildcardTypeImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedWildcardType {
        private final boolean hasUpperBounds;

        AnnotatedWildcardTypeImpl(WildcardType wildcardType, TypeAnnotation.LocationInfo locationInfo, TypeAnnotation[] typeAnnotationArray, TypeAnnotation[] typeAnnotationArray2, AnnotatedElement annotatedElement) {
            super(wildcardType, locationInfo, typeAnnotationArray, typeAnnotationArray2, annotatedElement);
            this.hasUpperBounds = wildcardType.getLowerBounds().length == 0;
        }

        @Override
        public AnnotatedType[] getAnnotatedUpperBounds() {
            if (!this.hasUpperBounds()) {
                return new AnnotatedType[0];
            }
            return this.getAnnotatedBounds(this.getWildcardType().getUpperBounds());
        }

        @Override
        public AnnotatedType[] getAnnotatedLowerBounds() {
            if (this.hasUpperBounds) {
                return new AnnotatedType[0];
            }
            return this.getAnnotatedBounds(this.getWildcardType().getLowerBounds());
        }

        private AnnotatedType[] getAnnotatedBounds(Type[] typeArray) {
            Object[] objectArray = new AnnotatedType[typeArray.length];
            Arrays.fill(objectArray, EMPTY_ANNOTATED_TYPE);
            TypeAnnotation.LocationInfo locationInfo = this.getLocation().pushWildcard();
            int n = this.getTypeAnnotations().length;
            for (int i = 0; i < objectArray.length; ++i) {
                ArrayList<TypeAnnotation> arrayList = new ArrayList<TypeAnnotation>(n);
                for (TypeAnnotation typeAnnotation : this.getTypeAnnotations()) {
                    if (!typeAnnotation.getLocationInfo().isSameLocationInfo(locationInfo)) continue;
                    arrayList.add(typeAnnotation);
                }
                objectArray[i] = AnnotatedTypeFactory.buildAnnotatedType(typeArray[i], locationInfo, arrayList.toArray(new TypeAnnotation[0]), this.getTypeAnnotations(), this.getDecl());
            }
            return objectArray;
        }

        private WildcardType getWildcardType() {
            return (WildcardType)this.getType();
        }

        private boolean hasUpperBounds() {
            return this.hasUpperBounds;
        }
    }

    private static final class AnnotatedParameterizedTypeImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedParameterizedType {
        AnnotatedParameterizedTypeImpl(ParameterizedType parameterizedType, TypeAnnotation.LocationInfo locationInfo, TypeAnnotation[] typeAnnotationArray, TypeAnnotation[] typeAnnotationArray2, AnnotatedElement annotatedElement) {
            super(parameterizedType, locationInfo, typeAnnotationArray, typeAnnotationArray2, annotatedElement);
        }

        @Override
        public AnnotatedType[] getAnnotatedActualTypeArguments() {
            Type[] typeArray = this.getParameterizedType().getActualTypeArguments();
            Object[] objectArray = new AnnotatedType[typeArray.length];
            Arrays.fill(objectArray, EMPTY_ANNOTATED_TYPE);
            int n = this.getTypeAnnotations().length;
            for (int i = 0; i < objectArray.length; ++i) {
                ArrayList<TypeAnnotation> arrayList = new ArrayList<TypeAnnotation>(n);
                TypeAnnotation.LocationInfo locationInfo = this.getLocation().pushTypeArg((byte)i);
                for (TypeAnnotation typeAnnotation : this.getTypeAnnotations()) {
                    if (!typeAnnotation.getLocationInfo().isSameLocationInfo(locationInfo)) continue;
                    arrayList.add(typeAnnotation);
                }
                objectArray[i] = AnnotatedTypeFactory.buildAnnotatedType(typeArray[i], locationInfo, arrayList.toArray(new TypeAnnotation[0]), this.getTypeAnnotations(), this.getDecl());
            }
            return objectArray;
        }

        private ParameterizedType getParameterizedType() {
            return (ParameterizedType)this.getType();
        }
    }

    private static final class AnnotatedTypeVariableImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedTypeVariable {
        AnnotatedTypeVariableImpl(TypeVariable<?> typeVariable, TypeAnnotation.LocationInfo locationInfo, TypeAnnotation[] typeAnnotationArray, TypeAnnotation[] typeAnnotationArray2, AnnotatedElement annotatedElement) {
            super(typeVariable, locationInfo, typeAnnotationArray, typeAnnotationArray2, annotatedElement);
        }

        @Override
        public AnnotatedType[] getAnnotatedBounds() {
            return this.getTypeVariable().getAnnotatedBounds();
        }

        private TypeVariable<?> getTypeVariable() {
            return (TypeVariable)this.getType();
        }
    }

    private static final class AnnotatedArrayTypeImpl
    extends AnnotatedTypeBaseImpl
    implements AnnotatedArrayType {
        AnnotatedArrayTypeImpl(Type type, TypeAnnotation.LocationInfo locationInfo, TypeAnnotation[] typeAnnotationArray, TypeAnnotation[] typeAnnotationArray2, AnnotatedElement annotatedElement) {
            super(type, locationInfo, typeAnnotationArray, typeAnnotationArray2, annotatedElement);
        }

        @Override
        public AnnotatedType getAnnotatedGenericComponentType() {
            return AnnotatedTypeFactory.buildAnnotatedType(this.getComponentType(), this.getLocation().pushArray(), this.getTypeAnnotations(), this.getTypeAnnotations(), this.getDecl());
        }

        private Type getComponentType() {
            Type type = this.getType();
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return clazz.getComponentType();
            }
            return ((GenericArrayType)type).getGenericComponentType();
        }
    }

    private static class AnnotatedTypeBaseImpl
    implements AnnotatedType {
        private final Type type;
        private final AnnotatedElement decl;
        private final TypeAnnotation.LocationInfo location;
        private final TypeAnnotation[] allOnSameTargetTypeAnnotations;
        private final Map<Class<? extends Annotation>, Annotation> annotations;

        AnnotatedTypeBaseImpl(Type type, TypeAnnotation.LocationInfo locationInfo, TypeAnnotation[] typeAnnotationArray, TypeAnnotation[] typeAnnotationArray2, AnnotatedElement annotatedElement) {
            this.type = type;
            this.decl = annotatedElement;
            this.location = locationInfo;
            this.allOnSameTargetTypeAnnotations = typeAnnotationArray2;
            this.annotations = TypeAnnotationParser.mapTypeAnnotations(locationInfo.filter(typeAnnotationArray));
        }

        @Override
        public final Annotation[] getAnnotations() {
            return this.getDeclaredAnnotations();
        }

        @Override
        public final <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return this.getDeclaredAnnotation(clazz);
        }

        @Override
        public final <T extends Annotation> T[] getAnnotationsByType(Class<T> clazz) {
            return this.getDeclaredAnnotationsByType(clazz);
        }

        @Override
        public final Annotation[] getDeclaredAnnotations() {
            return this.annotations.values().toArray(new Annotation[0]);
        }

        @Override
        public final <T extends Annotation> T getDeclaredAnnotation(Class<T> clazz) {
            return (T)this.annotations.get(clazz);
        }

        @Override
        public final <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> clazz) {
            return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.annotations, clazz);
        }

        @Override
        public final Type getType() {
            return this.type;
        }

        final TypeAnnotation.LocationInfo getLocation() {
            return this.location;
        }

        final TypeAnnotation[] getTypeAnnotations() {
            return this.allOnSameTargetTypeAnnotations;
        }

        final AnnotatedElement getDecl() {
            return this.decl;
        }
    }
}

