/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class UniqueIdentity {
    private BitArray id;

    public UniqueIdentity(BitArray bitArray) {
        this.id = bitArray;
    }

    public UniqueIdentity(byte[] byArray) {
        this.id = new BitArray(byArray.length * 8, byArray);
    }

    public UniqueIdentity(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        this.id = derValue.getUnalignedBitString(true);
    }

    public UniqueIdentity(DerValue derValue) throws IOException {
        this.id = derValue.getUnalignedBitString(true);
    }

    public String toString() {
        return "UniqueIdentity:" + this.id.toString() + "\n";
    }

    public void encode(DerOutputStream derOutputStream, byte by) throws IOException {
        byte[] byArray = this.id.toByteArray();
        int n = byArray.length * 8 - this.id.length();
        derOutputStream.write(by);
        derOutputStream.putLength(byArray.length + 1);
        derOutputStream.write(n);
        derOutputStream.write(byArray);
    }

    public boolean[] getId() {
        if (this.id == null) {
            return null;
        }
        return this.id.toBooleanArray();
    }
}

