/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.HmacCore;
import com.sun.crypto.provider.PKCS12PBECipherCore;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class HmacPKCS12PBESHA1
extends HmacCore {
    public HmacPKCS12PBESHA1() throws NoSuchAlgorithmException {
        super("SHA1", 64);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        char[] cArray;
        Object object;
        byte[] byArray = null;
        int n = 0;
        if (key instanceof PBEKey) {
            object = (PBEKey)key;
            cArray = object.getPassword();
            byArray = object.getSalt();
            n = object.getIterationCount();
        } else if (key instanceof SecretKey) {
            object = key.getEncoded();
            if (object == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
                throw new InvalidKeyException("Missing password");
            }
            cArray = new char[((Object)object).length];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(object[i] & 0x7F);
            }
        } else {
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        if (algorithmParameterSpec == null) {
            if (byArray == null || n == 0) {
                throw new InvalidAlgorithmParameterException("PBEParameterSpec required for salt and iteration count");
            }
        } else {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
            }
            object = (PBEParameterSpec)algorithmParameterSpec;
            if (byArray != null) {
                if (!Arrays.equals(byArray, ((PBEParameterSpec)object).getSalt())) {
                    throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                }
            } else {
                byArray = ((PBEParameterSpec)object).getSalt();
            }
            if (n != 0) {
                if (n != ((PBEParameterSpec)object).getIterationCount()) {
                    throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                }
            } else {
                n = ((PBEParameterSpec)object).getIterationCount();
            }
        }
        if (byArray.length < 8) {
            throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
        }
        if (n <= 0) {
            throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
        }
        object = PKCS12PBECipherCore.derive(cArray, byArray, n, this.engineGetMacLength(), 3);
        SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "HmacSHA1");
        super.engineInit(secretKeySpec, null);
    }
}

