#!/bin/sh

if ! [ -r $PWD/zen_ecdh.h ] && [ -z "$2" ] ; then
	echo "usage: ./codegen_ecdh_factory.sh CURVE_NAME"
	return 1
fi

CN="$1"

FILE="${2:-zen_ecdh_factory.c}"

cat <<EOF > "${FILE}"
// Generated by lua-zenroom codegen_ecdh_factory.sh
// `date`
#include <string.h>
#include <lauxlib.h>
#include <zen_ecdh.h>
#include <zen_error.h>
#include <ecdh_${CN}.h>

void ecdh_factory_init(ecdh *ECDH) {
	ECDH->fieldsize = EFS_${CN};
	ECDH->hash = HASH_TYPE_${CN};
	ECDH->ECP__KEY_PAIR_GENERATE = ECP_${CN}_KEY_PAIR_GENERATE;
	ECDH->ECP__PUBLIC_KEY_VALIDATE	= ECP_${CN}_PUBLIC_KEY_VALIDATE;
	ECDH->ECP__SVDP_DH = ECP_${CN}_SVDP_DH;
	ECDH->ECP__ECIES_ENCRYPT = ECP_${CN}_ECIES_ENCRYPT;
	ECDH->ECP__ECIES_DECRYPT = ECP_${CN}_ECIES_DECRYPT;
	ECDH->ECP__SP_DSA = ECP_${CN}_SP_DSA;
	ECDH->ECP__VP_DSA = ECP_${CN}_VP_DSA;
	ECDH->ECP__SP_DSA_NOHASH = ECP_${CN}_SP_DSA_NOHASH;
	ECDH->ECP__VP_DSA_NOHASH = ECP_${CN}_VP_DSA_NOHASH;
	act(NULL,"ECDH curve is ${CN}");
}
EOF
