/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicLong
extends Number
implements Serializable {
    private static final long serialVersionUID = 1927816293512124184L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    static final boolean VM_SUPPORTS_LONG_CAS;
    private volatile long value;

    private static native boolean VMSupportsCS8();

    public AtomicLong(long l) {
        this.value = l;
    }

    public AtomicLong() {
    }

    public final long get() {
        return this.value;
    }

    public final void set(long l) {
        this.value = l;
    }

    public final void lazySet(long l) {
        unsafe.putOrderedLong(this, valueOffset, l);
    }

    public final long getAndSet(long l) {
        long l2;
        while (!this.compareAndSet(l2 = this.get(), l)) {
        }
        return l2;
    }

    public final boolean compareAndSet(long l, long l2) {
        return unsafe.compareAndSwapLong(this, valueOffset, l, l2);
    }

    public final boolean weakCompareAndSet(long l, long l2) {
        return unsafe.compareAndSwapLong(this, valueOffset, l, l2);
    }

    public final long getAndIncrement() {
        long l;
        long l2;
        while (!this.compareAndSet(l2 = this.get(), l = l2 + 1L)) {
        }
        return l2;
    }

    public final long getAndDecrement() {
        long l;
        long l2;
        while (!this.compareAndSet(l2 = this.get(), l = l2 - 1L)) {
        }
        return l2;
    }

    public final long getAndAdd(long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2 = l3 + l)) {
        }
        return l3;
    }

    public final long incrementAndGet() {
        long l;
        long l2;
        while (!this.compareAndSet(l2 = this.get(), l = l2 + 1L)) {
        }
        return l;
    }

    public final long decrementAndGet() {
        long l;
        long l2;
        while (!this.compareAndSet(l2 = this.get(), l = l2 - 1L)) {
        }
        return l;
    }

    public final long addAndGet(long l) {
        long l2;
        long l3;
        while (!this.compareAndSet(l3 = this.get(), l2 = l3 + l)) {
        }
        return l2;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    static {
        VM_SUPPORTS_LONG_CAS = AtomicLong.VMSupportsCS8();
        try {
            valueOffset = unsafe.objectFieldOffset(AtomicLong.class.getDeclaredField("value"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

