/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.spec.ECParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.JsseJce;
import sun.security.ssl.SunJSSE;

final class SupportedEllipticCurvesExtension
extends HelloExtension {
    static final SupportedEllipticCurvesExtension DEFAULT;
    private static final boolean fips;
    private final int[] curveIds;
    private static final int ARBITRARY_PRIME = 65281;
    private static final int ARBITRARY_CHAR2 = 65282;
    private static final String[] NAMED_CURVE_OID_TABLE;
    private static final Map<String, Integer> curveIndices;

    private SupportedEllipticCurvesExtension(int[] nArray) {
        super(ExtensionType.EXT_ELLIPTIC_CURVES);
        this.curveIds = nArray;
    }

    SupportedEllipticCurvesExtension(HandshakeInStream handshakeInStream, int n) throws IOException {
        super(ExtensionType.EXT_ELLIPTIC_CURVES);
        int n2 = handshakeInStream.getInt16();
        if ((n & 1) != 0 || n2 + 2 != n) {
            throw new SSLProtocolException("Invalid " + this.type + " extension");
        }
        this.curveIds = new int[n2 >> 1];
        for (int i = 0; i < this.curveIds.length; ++i) {
            this.curveIds[i] = handshakeInStream.getInt16();
        }
    }

    boolean contains(int n) {
        for (int n2 : this.curveIds) {
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    int[] curveIds() {
        return this.curveIds;
    }

    @Override
    int length() {
        return 6 + (this.curveIds.length << 1);
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(this.type.id);
        int n = this.curveIds.length << 1;
        handshakeOutStream.putInt16(n + 2);
        handshakeOutStream.putInt16(n);
        for (int n2 : this.curveIds) {
            handshakeOutStream.putInt16(n2);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Extension " + this.type + ", curve names: {");
        boolean bl = true;
        for (int n : this.curveIds) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            String string = SupportedEllipticCurvesExtension.getCurveOid(n);
            if (string != null) {
                ECParameterSpec eCParameterSpec = JsseJce.getECParameterSpec(string);
                if (eCParameterSpec != null) {
                    stringBuilder.append(eCParameterSpec.toString().split(" ")[0]);
                    continue;
                }
                stringBuilder.append(string);
                continue;
            }
            if (n == 65281) {
                stringBuilder.append("arbitrary_explicit_prime_curves");
                continue;
            }
            if (n == 65282) {
                stringBuilder.append("arbitrary_explicit_char2_curves");
                continue;
            }
            stringBuilder.append("unknown curve " + n);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    static boolean isSupported(int n) {
        if (n <= 0 || n >= NAMED_CURVE_OID_TABLE.length) {
            return false;
        }
        if (!fips) {
            return true;
        }
        return DEFAULT.contains(n);
    }

    static int getCurveIndex(ECParameterSpec eCParameterSpec) {
        String string = JsseJce.getNamedCurveOid(eCParameterSpec);
        if (string == null) {
            return -1;
        }
        Integer n = curveIndices.get(string);
        return n == null ? -1 : n;
    }

    static String getCurveOid(int n) {
        if (n > 0 && n < NAMED_CURVE_OID_TABLE.length) {
            return NAMED_CURVE_OID_TABLE[n];
        }
        return null;
    }

    static {
        fips = SunJSSE.isFIPS();
        int[] nArray = !fips ? new int[]{23, 1, 3, 19, 21, 6, 7, 9, 10, 24, 11, 12, 25, 13, 14, 15, 16, 17, 2, 18, 4, 5, 20, 8, 22} : new int[]{23, 1, 3, 19, 21, 6, 7, 9, 10, 24, 11, 12, 25, 13, 14};
        DEFAULT = new SupportedEllipticCurvesExtension(nArray);
        NAMED_CURVE_OID_TABLE = new String[]{null, "1.3.132.0.1", "1.3.132.0.2", "1.3.132.0.15", "1.3.132.0.24", "1.3.132.0.25", "1.3.132.0.26", "1.3.132.0.27", "1.3.132.0.3", "1.3.132.0.16", "1.3.132.0.17", "1.3.132.0.36", "1.3.132.0.37", "1.3.132.0.38", "1.3.132.0.39", "1.3.132.0.9", "1.3.132.0.8", "1.3.132.0.30", "1.3.132.0.31", "1.2.840.10045.3.1.1", "1.3.132.0.32", "1.3.132.0.33", "1.3.132.0.10", "1.2.840.10045.3.1.7", "1.3.132.0.34", "1.3.132.0.35"};
        curveIndices = new HashMap<String, Integer>();
        for (int i = 1; i < NAMED_CURVE_OID_TABLE.length; ++i) {
            curveIndices.put(NAMED_CURVE_OID_TABLE[i], i);
        }
    }
}

