/*
 * Decompiled with CFR 0.152.
 */
package sun.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class PreHashedMap<V>
extends AbstractMap<String, V> {
    private final int rows;
    private final int size;
    private final int shift;
    private final int mask;
    private final Object[] ht;

    protected PreHashedMap(int n, int n2, int n3, int n4) {
        this.rows = n;
        this.size = n2;
        this.shift = n3;
        this.mask = n4;
        this.ht = new Object[n];
        this.init(this.ht);
    }

    protected abstract void init(Object[] var1);

    private V toV(Object object) {
        return (V)object;
    }

    @Override
    public V get(Object object) {
        int n = object.hashCode() >> this.shift & this.mask;
        Object[] objectArray = (Object[])this.ht[n];
        if (objectArray == null) {
            return null;
        }
        while (!objectArray[0].equals(object)) {
            if (objectArray.length < 3) {
                return null;
            }
            objectArray = (Object[])objectArray[2];
        }
        return this.toV(objectArray[1]);
    }

    @Override
    public V put(String string, V v) {
        int n = string.hashCode() >> this.shift & this.mask;
        Object[] objectArray = (Object[])this.ht[n];
        if (objectArray == null) {
            throw new UnsupportedOperationException(string);
        }
        while (true) {
            if (objectArray[0].equals(string)) {
                V v2 = this.toV(objectArray[1]);
                objectArray[1] = v;
                return v2;
            }
            if (objectArray.length < 3) {
                throw new UnsupportedOperationException(string);
            }
            objectArray = (Object[])objectArray[2];
        }
    }

    @Override
    public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public int size() {
                return PreHashedMap.this.size;
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int i = -1;
                    Object[] a = null;
                    String cur = null;

                    private boolean findNext() {
                        if (this.a != null) {
                            if (this.a.length == 3) {
                                this.a = (Object[])this.a[2];
                                this.cur = (String)this.a[0];
                                return true;
                            }
                            ++this.i;
                            this.a = null;
                        }
                        this.cur = null;
                        if (this.i >= PreHashedMap.this.rows) {
                            return false;
                        }
                        if (this.i < 0 || PreHashedMap.this.ht[this.i] == null) {
                            do {
                                if (++this.i < PreHashedMap.this.rows) continue;
                                return false;
                            } while (PreHashedMap.this.ht[this.i] == null);
                        }
                        this.a = (Object[])PreHashedMap.this.ht[this.i];
                        this.cur = (String)this.a[0];
                        return true;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.cur != null) {
                            return true;
                        }
                        return this.findNext();
                    }

                    @Override
                    public String next() {
                        if (this.cur == null && !this.findNext()) {
                            throw new NoSuchElementException();
                        }
                        String string = this.cur;
                        this.cur = null;
                        return string;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new AbstractSet<Map.Entry<String, V>>(){

            @Override
            public int size() {
                return PreHashedMap.this.size;
            }

            @Override
            public Iterator<Map.Entry<String, V>> iterator() {
                return new Iterator<Map.Entry<String, V>>(){
                    final Iterator<String> i;
                    {
                        this.i = PreHashedMap.this.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<String, V> next() {
                        return new Map.Entry<String, V>(){
                            String k;
                            {
                                this.k = i.next();
                            }

                            @Override
                            public String getKey() {
                                return this.k;
                            }

                            @Override
                            public V getValue() {
                                return PreHashedMap.this.get(this.k);
                            }

                            @Override
                            public int hashCode() {
                                Object v = PreHashedMap.this.get(this.k);
                                return this.k.hashCode() + (v == null ? 0 : v.hashCode());
                            }

                            @Override
                            public boolean equals(Object object) {
                                if (object == this) {
                                    return true;
                                }
                                if (!(object instanceof Map.Entry)) {
                                    return false;
                                }
                                Map.Entry entry = (Map.Entry)object;
                                return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
                            }

                            @Override
                            public V setValue(V v) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

