/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import sun.lwawt.macosx.CImage;

public class CCustomCursor
extends Cursor {
    static Dimension sMaxCursorSize;
    Image fImage;
    Point fHotspot;
    CImage fCImage;

    static Dimension getMaxCursorSize() {
        if (sMaxCursorSize != null) {
            return sMaxCursorSize;
        }
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        sMaxCursorSize = new Dimension(rectangle.width / 2, rectangle.height / 2);
        return sMaxCursorSize;
    }

    public CCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException, HeadlessException {
        super(string);
        this.fImage = image;
        this.fHotspot = point;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Canvas canvas = new Canvas();
        MediaTracker mediaTracker = new MediaTracker(canvas);
        mediaTracker.addImage(this.fImage, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = this.fImage.getWidth(canvas);
        int n2 = this.fImage.getHeight(canvas);
        if (mediaTracker.isErrorAny() || n < 0 || n2 < 0) {
            this.fHotspot.y = 0;
            this.fHotspot.x = 0;
            n2 = 1;
            n = 1;
            this.fImage = CCustomCursor.createTransparentImage(n, n2);
        } else {
            Dimension dimension = toolkit.getBestCursorSize(n, n2);
            if (dimension.width != n || dimension.height != n2) {
                this.fImage = this.fImage.getScaledInstance(dimension.width, dimension.height, 1);
                n = dimension.width;
                n2 = dimension.height;
            }
        }
        if (this.fHotspot.x >= n || this.fHotspot.y >= n2 || this.fHotspot.x < 0 || this.fHotspot.y < 0) {
            throw new IndexOutOfBoundsException("invalid hotSpot");
        }
        if (this.fHotspot.x >= n) {
            this.fHotspot.x = n - 1;
        } else if (this.fHotspot.x < 0) {
            this.fHotspot.x = 0;
        }
        if (this.fHotspot.y >= n2) {
            this.fHotspot.y = n2 - 1;
        } else if (this.fHotspot.y < 0) {
            this.fHotspot.y = 0;
        }
    }

    private static BufferedImage createTransparentImage(int n, int n2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setBackground(new Color(0, 0, 0, 0));
        graphics2D.clearRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Dimension getBestCursorSize(int n, int n2) {
        Dimension dimension = CCustomCursor.getMaxCursorSize();
        Dimension dimension2 = new Dimension(Math.max(1, Math.abs(n)), Math.max(1, Math.abs(n2)));
        return new Dimension(Math.min(dimension2.width, dimension.width), Math.min(dimension2.height, dimension.height));
    }

    long getImageData() {
        if (this.fCImage != null) {
            return this.fCImage.ptr;
        }
        try {
            this.fCImage = CImage.getCreator().createFromImage(this.fImage);
            if (this.fCImage == null) {
                return 0L;
            }
            return this.fCImage.ptr;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0L;
        }
    }

    Point getHotSpot() {
        return this.fHotspot;
    }
}

