/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.NamedCurve;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public final class ECParameters
extends AlgorithmParametersSpi {
    private ECParameterSpec paramSpec;

    public static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException("Only uncompressed point format supported");
        }
        int n = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        if (byArray.length != n * 2 + 1) {
            throw new IOException("Point does not match field size");
        }
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 1, byArray2, 0, n);
        System.arraycopy(byArray, n + 1, byArray3, 0, n);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    public static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        byte[] byArray = ECParameters.trimZeroes(eCPoint.getAffineX().toByteArray());
        byte[] byArray2 = ECParameters.trimZeroes(eCPoint.getAffineY().toByteArray());
        if (byArray.length > n || byArray2.length > n) {
            throw new RuntimeException("Point coordinates do not match field size");
        }
        byte[] byArray3 = new byte[1 + (n << 1)];
        byArray3[0] = 4;
        System.arraycopy(byArray, 0, byArray3, n - byArray.length + 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        return byArray3;
    }

    static byte[] trimZeroes(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length - 1 && byArray[n] == 0; ++n) {
        }
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static NamedCurve getNamedCurve(ECParameterSpec eCParameterSpec) {
        if (eCParameterSpec instanceof NamedCurve || eCParameterSpec == null) {
            return (NamedCurve)eCParameterSpec;
        }
        int n = eCParameterSpec.getCurve().getField().getFieldSize();
        for (ECParameterSpec eCParameterSpec2 : NamedCurve.knownECParameterSpecs()) {
            if (eCParameterSpec2.getCurve().getField().getFieldSize() != n || !eCParameterSpec2.getCurve().equals(eCParameterSpec.getCurve()) || !eCParameterSpec2.getGenerator().equals(eCParameterSpec.getGenerator()) || !eCParameterSpec2.getOrder().equals(eCParameterSpec.getOrder()) || eCParameterSpec2.getCofactor() != eCParameterSpec.getCofactor()) continue;
            return (NamedCurve)eCParameterSpec2;
        }
        return null;
    }

    public static String getCurveName(ECParameterSpec eCParameterSpec) {
        NamedCurve namedCurve = ECParameters.getNamedCurve(eCParameterSpec);
        return namedCurve == null ? null : namedCurve.getObjectIdentifier().toString();
    }

    public static byte[] encodeParameters(ECParameterSpec eCParameterSpec) {
        NamedCurve namedCurve = ECParameters.getNamedCurve(eCParameterSpec);
        if (namedCurve == null) {
            throw new RuntimeException("Not a known named curve: " + eCParameterSpec);
        }
        return namedCurve.getEncoded();
    }

    public static ECParameterSpec decodeParameters(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag == 6) {
            ObjectIdentifier objectIdentifier = derValue.getOID();
            ECParameterSpec eCParameterSpec = NamedCurve.getECParameterSpec(objectIdentifier);
            if (eCParameterSpec == null) {
                throw new IOException("Unknown named curve: " + objectIdentifier);
            }
            return eCParameterSpec;
        }
        throw new IOException("Only named ECParameters supported");
    }

    static AlgorithmParameters getAlgorithmParameters(ECParameterSpec eCParameterSpec) throws InvalidKeyException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC", ECKeyFactory.ecInternalProvider);
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("EC parameters error", generalSecurityException);
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.paramSpec = ECParameters.getNamedCurve((ECParameterSpec)algorithmParameterSpec);
            if (this.paramSpec == null) {
                throw new InvalidParameterSpecException("Not a supported named curve: " + algorithmParameterSpec);
            }
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
            ECParameterSpec eCParameterSpec = NamedCurve.getECParameterSpec(string);
            if (eCParameterSpec == null) {
                throw new InvalidParameterSpecException("Unknown curve: " + string);
            }
            this.paramSpec = eCParameterSpec;
        } else {
            if (algorithmParameterSpec == null) {
                throw new InvalidParameterSpecException("paramSpec must not be null");
            }
            throw new InvalidParameterSpecException("Only ECParameterSpec and ECGenParameterSpec supported");
        }
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        this.paramSpec = ECParameters.decodeParameters(byArray);
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (clazz.isAssignableFrom(ECParameterSpec.class)) {
            return (T)this.paramSpec;
        }
        if (clazz.isAssignableFrom(ECGenParameterSpec.class)) {
            return (T)new ECGenParameterSpec(ECParameters.getCurveName(this.paramSpec));
        }
        throw new InvalidParameterSpecException("Only ECParameterSpec and ECGenParameterSpec supported");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return ECParameters.encodeParameters(this.paramSpec);
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return this.paramSpec.toString();
    }
}

