/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.InMemoryCookieStore;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.util.logging.PlatformLogger;

public class CookieManager
extends CookieHandler {
    private CookiePolicy policyCallback;
    private CookieStore cookieJar = null;

    public CookieManager() {
        this(null, null);
    }

    public CookieManager(CookieStore cookieStore, CookiePolicy cookiePolicy) {
        this.policyCallback = cookiePolicy == null ? CookiePolicy.ACCEPT_ORIGINAL_SERVER : cookiePolicy;
        this.cookieJar = cookieStore == null ? new InMemoryCookieStore() : cookieStore;
    }

    public void setCookiePolicy(CookiePolicy cookiePolicy) {
        if (cookiePolicy != null) {
            this.policyCallback = cookiePolicy;
        }
    }

    public CookieStore getCookieStore() {
        return this.cookieJar;
    }

    @Override
    public Map<String, List<String>> get(URI uRI, Map<String, List<String>> map) throws IOException {
        if (uRI == null || map == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.cookieJar == null) {
            return Collections.unmodifiableMap(hashMap);
        }
        boolean bl = "https".equalsIgnoreCase(uRI.getScheme());
        ArrayList<HttpCookie> arrayList = new ArrayList<HttpCookie>();
        String string = uRI.getPath();
        if (string == null || string.isEmpty()) {
            string = "/";
        }
        for (HttpCookie httpCookie : this.cookieJar.get(uRI)) {
            String string2;
            if (!this.pathMatches(string, httpCookie.getPath()) || !bl && httpCookie.getSecure() || httpCookie.isHttpOnly() && !"http".equalsIgnoreCase(string2 = uRI.getScheme()) && !"https".equalsIgnoreCase(string2)) continue;
            string2 = httpCookie.getPortlist();
            if (string2 != null && !string2.isEmpty()) {
                int n = uRI.getPort();
                if (n == -1) {
                    int n2 = n = "https".equals(uRI.getScheme()) ? 443 : 80;
                }
                if (!CookieManager.isInPortList(string2, n)) continue;
                arrayList.add(httpCookie);
                continue;
            }
            arrayList.add(httpCookie);
        }
        List<String> list = this.sortByPath(arrayList);
        hashMap.put("Cookie", list);
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public void put(URI uRI, Map<String, List<String>> map) throws IOException {
        if (uRI == null || map == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        if (this.cookieJar == null) {
            return;
        }
        PlatformLogger platformLogger = PlatformLogger.getLogger("java.net.CookieManager");
        for (String string : map.keySet()) {
            if (string == null || !string.equalsIgnoreCase("Set-Cookie2") && !string.equalsIgnoreCase("Set-Cookie")) continue;
            for (String string2 : map.get(string)) {
                try {
                    List<HttpCookie> list;
                    block16: {
                        try {
                            list = HttpCookie.parse(string2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            list = Collections.emptyList();
                            if (!platformLogger.isLoggable(PlatformLogger.Level.SEVERE)) break block16;
                            platformLogger.severe("Invalid cookie for " + uRI + ": " + string2);
                        }
                    }
                    for (HttpCookie httpCookie : list) {
                        int n;
                        String string3;
                        if (httpCookie.getPath() == null) {
                            string3 = uRI.getPath();
                            if (!string3.endsWith("/")) {
                                n = string3.lastIndexOf("/");
                                string3 = n > 0 ? string3.substring(0, n + 1) : "/";
                            }
                            httpCookie.setPath(string3);
                        }
                        if (httpCookie.getDomain() == null) {
                            string3 = uRI.getHost();
                            if (string3 != null && !string3.contains(".")) {
                                string3 = string3 + ".local";
                            }
                            httpCookie.setDomain(string3);
                        }
                        if ((string3 = httpCookie.getPortlist()) != null) {
                            n = uRI.getPort();
                            if (n == -1) {
                                int n2 = n = "https".equals(uRI.getScheme()) ? 443 : 80;
                            }
                            if (string3.isEmpty()) {
                                httpCookie.setPortlist("" + n);
                                if (!this.shouldAcceptInternal(uRI, httpCookie)) continue;
                                this.cookieJar.add(uRI, httpCookie);
                                continue;
                            }
                            if (!CookieManager.isInPortList(string3, n) || !this.shouldAcceptInternal(uRI, httpCookie)) continue;
                            this.cookieJar.add(uRI, httpCookie);
                            continue;
                        }
                        if (!this.shouldAcceptInternal(uRI, httpCookie)) continue;
                        this.cookieJar.add(uRI, httpCookie);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
    }

    private boolean shouldAcceptInternal(URI uRI, HttpCookie httpCookie) {
        try {
            return this.policyCallback.shouldAccept(uRI, httpCookie);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isInPortList(String string, int n) {
        int n2 = string.indexOf(",");
        int n3 = -1;
        while (n2 > 0) {
            try {
                n3 = Integer.parseInt(string.substring(0, n2));
                if (n3 == n) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string = string.substring(n2 + 1);
            n2 = string.indexOf(",");
        }
        if (!string.isEmpty()) {
            try {
                n3 = Integer.parseInt(string);
                if (n3 == n) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean pathMatches(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.startsWith(string2);
    }

    private List<String> sortByPath(List<HttpCookie> list) {
        Collections.sort(list, new CookiePathComparator());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HttpCookie httpCookie : list) {
            if (list.indexOf(httpCookie) == 0 && httpCookie.getVersion() > 0) {
                arrayList.add("$Version=\"1\"");
            }
            arrayList.add(httpCookie.toString());
        }
        return arrayList;
    }

    static class CookiePathComparator
    implements Comparator<HttpCookie> {
        CookiePathComparator() {
        }

        @Override
        public int compare(HttpCookie httpCookie, HttpCookie httpCookie2) {
            if (httpCookie == httpCookie2) {
                return 0;
            }
            if (httpCookie == null) {
                return -1;
            }
            if (httpCookie2 == null) {
                return 1;
            }
            if (!httpCookie.getName().equals(httpCookie2.getName())) {
                return 0;
            }
            if (httpCookie.getPath().startsWith(httpCookie2.getPath())) {
                return -1;
            }
            if (httpCookie2.getPath().startsWith(httpCookie.getPath())) {
                return 1;
            }
            return 0;
        }
    }
}

