/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.time.ZoneOffset;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;

final class Ser
implements Externalizable {
    private static final long serialVersionUID = -8885321777449118786L;
    static final byte ZRULES = 1;
    static final byte ZOT = 2;
    static final byte ZOTRULE = 3;
    private byte type;
    private Object object;

    public Ser() {
    }

    Ser(byte by, Object object) {
        this.type = by;
        this.object = object;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Ser.writeInternal(this.type, this.object, objectOutput);
    }

    static void write(Object object, DataOutput dataOutput) throws IOException {
        Ser.writeInternal((byte)1, object, dataOutput);
    }

    private static void writeInternal(byte by, Object object, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(by);
        switch (by) {
            case 1: {
                ((ZoneRules)object).writeExternal(dataOutput);
                break;
            }
            case 2: {
                ((ZoneOffsetTransition)object).writeExternal(dataOutput);
                break;
            }
            case 3: {
                ((ZoneOffsetTransitionRule)object).writeExternal(dataOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.type = objectInput.readByte();
        this.object = Ser.readInternal(this.type, objectInput);
    }

    static Object read(DataInput dataInput) throws IOException, ClassNotFoundException {
        byte by = dataInput.readByte();
        return Ser.readInternal(by, dataInput);
    }

    private static Object readInternal(byte by, DataInput dataInput) throws IOException, ClassNotFoundException {
        switch (by) {
            case 1: {
                return ZoneRules.readExternal(dataInput);
            }
            case 2: {
                return ZoneOffsetTransition.readExternal(dataInput);
            }
            case 3: {
                return ZoneOffsetTransitionRule.readExternal(dataInput);
            }
        }
        throw new StreamCorruptedException("Unknown serialized type");
    }

    private Object readResolve() {
        return this.object;
    }

    static void writeOffset(ZoneOffset zoneOffset, DataOutput dataOutput) throws IOException {
        int n = zoneOffset.getTotalSeconds();
        int n2 = n % 900 == 0 ? n / 900 : 127;
        dataOutput.writeByte(n2);
        if (n2 == 127) {
            dataOutput.writeInt(n);
        }
    }

    static ZoneOffset readOffset(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        return by == 127 ? ZoneOffset.ofTotalSeconds(dataInput.readInt()) : ZoneOffset.ofTotalSeconds(by * 900);
    }

    static void writeEpochSec(long l, DataOutput dataOutput) throws IOException {
        if (l >= -4575744000L && l < 10413792000L && l % 900L == 0L) {
            int n = (int)((l + 4575744000L) / 900L);
            dataOutput.writeByte(n >>> 16 & 0xFF);
            dataOutput.writeByte(n >>> 8 & 0xFF);
            dataOutput.writeByte(n & 0xFF);
        } else {
            dataOutput.writeByte(255);
            dataOutput.writeLong(l);
        }
    }

    static long readEpochSec(DataInput dataInput) throws IOException {
        int n = dataInput.readByte() & 0xFF;
        if (n == 255) {
            return dataInput.readLong();
        }
        int n2 = dataInput.readByte() & 0xFF;
        int n3 = dataInput.readByte() & 0xFF;
        long l = (n << 16) + (n2 << 8) + n3;
        return l * 900L - 4575744000L;
    }
}

